#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "tree.h"
#include "global.h"
#include "flist.h"
#include "lowlevel.h"

static char pref_window_status = 0;

extern struct _settings *settings;
struct _settings *new_settings;


extern void show_preferences (GtkWidget *widget, gpointer *data);
extern void read_preferences ();

int read_pref_file (char *filename);
void write_preferences_file ();
void exit_preferences (GtkWidget *widget, gpointer *window);
void write_exit_preferences (GtkWidget *widget, gpointer *data);
void toggle_check_item (GtkWidget *widget, gpointer *checkbox_number);

GtkWidget *file_list_pref_box ();

/*
 * show_preferences shows a window in which preferences can be altered
 * if another window == active, return silently
 */
void show_preferences (GtkWidget *widget, gpointer *data)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *notebook, *page;
	GtkWidget *buttonbox;
	GtkWidget *button;
	GtkWidget *label;

	/* check wheter another pref window is active */
	if (pref_window_status == 1) return;
	pref_window_status = 1;

	/* make a copy of the settings in memory */
	new_settings = (struct _settings *)malloc (sizeof (struct _settings));
	memcpy (new_settings, settings, sizeof(struct _settings));

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(exit_preferences), window);

	gtk_container_set_border_width (GTK_CONTAINER(window), 10);
	vbox = gtk_vbox_new (FALSE, 30);
	gtk_container_add (GTK_CONTAINER(window), vbox);
	gtk_widget_show (vbox);

	label = gtk_label_new ("Select a subject.");
	gtk_widget_set_usize (label,400,16);
	gtk_widget_show(label);
	gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);
	notebook = gtk_notebook_new ();
	gtk_widget_show (notebook);
	gtk_box_pack_start (GTK_BOX(vbox), notebook, FALSE, FALSE, 0);

	page = file_list_pref_box ();
	label = gtk_label_new ("file list");
	gtk_widget_show (label);
	gtk_notebook_append_page (GTK_NOTEBOOK(notebook), page, label);


	buttonbox = gtk_hbox_new (TRUE, 20);
	gtk_widget_show (buttonbox);

	button = gtk_button_new_with_label ("Ok");
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX(buttonbox), button, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(write_exit_preferences), window);

	button = gtk_button_new_with_label ("Cancel");
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX(buttonbox), button, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(exit_preferences), window);

	gtk_box_pack_start (GTK_BOX(vbox), buttonbox, FALSE, FALSE, 0);

	gtk_widget_show (window);
}

/*
 * this is a helper function for show_preferences. it creates a vbox for
 * the first page in the notebook.
 */
GtkWidget *file_list_pref_box ()
{
	GtkWidget *vbox;
	GtkWidget *check;
	GtkWidget *frame;
	int i;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_widget_show (vbox);
	for (i=0;i<NUM_SETTINGS_LIST_ITEMS;i++) {
		check = gtk_check_button_new_with_label (column_headers[i]);
		gtk_widget_show(check);
		gtk_box_pack_start (GTK_BOX(vbox), check, FALSE, FALSE, 0);
		if (settings->list_items[i] == TRUE)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check), TRUE);
		gtk_signal_connect (GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(toggle_check_item),(gpointer)i);
	}
	frame = gtk_frame_new("Fields shown in file list");
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_container_set_border_width (GTK_CONTAINER(frame),10);
	gtk_widget_show (frame);

	return frame;
}

GtkWidget *misc_pref_box ()
{
/*	GtkWidget *vbox;*/
	/* hide dot files */
	/* display size (bytes/K/M/as fit) */
	/* show buttonbar */
	/* show users and groups as names*/
	return NULL;
}

/*
 * write_preferences_file writes the current preferences to $HOME/.uxplorc
 * it silently exits on errors
 */
void write_preferences_file ()
{
	char *homedir;
	char *name;
	FILE *filedes;
	homedir = getenv ("HOME");
	if (homedir != NULL) {
		name= completename (homedir,".uxplorc");
		if ((filedes = fopen (name,"w")) == NULL) return;
		fwrite (settings, sizeof(struct _settings),1,filedes);
		free(name);
	fclose (filedes);
	}
}

/*
 * exit editting preferences without making changes.
 */
void exit_preferences (GtkWidget *widget, gpointer *window)
{
	pref_window_status=0;
	gtk_widget_destroy ((GtkWidget *)window);
//	free (new_settings);
}

/*
 * write the new settings to a file, change the interface, and exit the window
 */
void write_exit_preferences (GtkWidget *widget, gpointer *window)
{
	settings = (struct _settings *)malloc (sizeof (struct _settings));
	memcpy (settings, new_settings, sizeof (struct _settings));
	write_preferences_file ();
	flist_reconfigure ();
	pref_window_status=0;
	gtk_widget_destroy ((GtkWidget *)window);
}

/*
 * read the preferences from (in order) $HOME/.uxplorc, /etc/uxplorc
 * or use default settings.
 */
void read_preferences ()
{
	char *homedir, *name;
	struct stat buf;
	int status;

	settings = (struct _settings *) malloc (sizeof (struct _settings));

	homedir = getenv ("HOME");
	if (homedir != NULL) {
		name = completename (homedir, ".uxplorc");
		status = stat (name, &buf);
		if (status == 0) {
			if(read_pref_file (name)) {
				free (name);
				return;
			}
		}
		free (name);
	}
	name = "/etc/uxplorc";
	status = stat (name, &buf);
	if (status == 0) {
		if (read_pref_file (name)) return;
	}

	settings->list_items[0] = TRUE;
	settings->list_items[1] = FALSE;
	settings->list_items[2] = FALSE;
	settings->list_items[3] = FALSE;
	settings->list_items[4] = TRUE;
	settings->list_items[5] = FALSE;
	settings->list_items[6] = FALSE;

	return;
}

/*
 * read a preferences file, returns FALSE if the file can not be opened
 * it does not check for bad contents (yeah, screw up my program)
 */
int read_pref_file (char *filename)
{
	FILE *filedes;

	filedes=fopen(filename,"r");
	if (filedes == NULL) return FALSE;
	fread (settings, sizeof(struct _settings),1,filedes);
	fclose (filedes);
	return TRUE;
}

/*
 * take care of stuff when a button was toggled
 */
void toggle_check_item (GtkWidget *widget, gpointer *checkbox_number)
{
	new_settings->list_items[(int)checkbox_number] = !(new_settings->list_items[(int)checkbox_number]);
}

