
#include <gtk/gtk.h>
#include "init.h"
#include <stdio.h>
#include "selection.h"
#include "preferences.h"
#include "global.h"
#include "dir.h"
#include "flist.h"
#include "tree.h"
#include "search.h"

extern GtkWidget *NewMenuBar(GtkWidget *window);
extern GtkWidget *NewDirPopup (GtkWidget *window);
extern void about();

static GtkItemFactoryEntry menu_items[] =
{
	{"/File/Execute",               "",           GTK_SIGNAL_FUNC(open_selection),         0,         NULL},
	{"/File/<separator>",           NULL,         NULL,                                    0,         "<Separator>"},
	{"/File/Delete",                "<alt>D",     GTK_SIGNAL_FUNC(delete_selection),       0,         NULL},
	{"/File/Rename",                "<control>R", GTK_SIGNAL_FUNC(rename_selection),       0,         NULL},
	{"/File/New directory",         "<control>D", GTK_SIGNAL_FUNC(make_new_dir),           0,         NULL},
	{"/File/<separator>",           NULL,         NULL,                                    0,         "<Separator>"},
	{"/File/Quit",                  "<control>Q",    GTK_SIGNAL_FUNC(exit_callback),       0,         NULL},
	{"/Edit/Find",                  "<control>F", GTK_SIGNAL_FUNC(search_show),	           0,         NULL},
	{"/Edit/<separator>",           NULL,         NULL,                                    0,         "<Separator>"},
	{"/Edit/Cut",                   "<control>X", GTK_SIGNAL_FUNC(selection_to_clipboard), MOVE_FILE, NULL},
	{"/Edit/Copy",                  "<control>C", GTK_SIGNAL_FUNC(selection_to_clipboard), COPY_FILE, NULL},
	{"/Edit/Paste",                 "<control>V", GTK_SIGNAL_FUNC(paste_clipboard),        0,         NULL},
	{"/Selection/Select all",       "<control>A", GTK_SIGNAL_FUNC(flist_select_all),       0,         NULL},
	{"/Selection/Invert selection", "<control>I", GTK_SIGNAL_FUNC(flist_select_invert),    0,         NULL},
	{"/Options/Preferences",        NULL,         GTK_SIGNAL_FUNC(show_preferences),       0,         NULL},
	{"/View/Refresh",               "F5",         GTK_SIGNAL_FUNC(refreshlist),            0,         NULL},
	{"/Help/About",                 "F1",         GTK_SIGNAL_FUNC(about),                  0,         NULL}
};

static GtkItemFactoryEntry popup_items[] =
{
	{"/Open",          "",   GTK_SIGNAL_FUNC(open_selection),         0, NULL},
	{"/<separator>",   NULL, NULL,                                    0, "<Separator>"},
	{"/Edit",          "",   GTK_SIGNAL_FUNC(Xedit_selection),        0, NULL},
	{"/Cmd Here",      "",   GTK_SIGNAL_FUNC(Cmd_prompt_here),        0, NULL},
	{"/<separator>",   NULL, NULL,                                    0, "<Separator>"},
	{"/SendTo:",       "",   GTK_SIGNAL_FUNC(sendto_selection),       0, NULL},
	{"/<separator>",   NULL, NULL,                                    0, "<Separator>"},
	{"/Cut",           "",   GTK_SIGNAL_FUNC(selection_to_clipboard), MOVE_FILE,  NULL},
	{"/Copy",          "",   GTK_SIGNAL_FUNC(selection_to_clipboard), COPY_FILE,  NULL},
	{"/Paste",         "",   GTK_SIGNAL_FUNC(paste_clipboard),        0, NULL},
	{"/<separator>",   NULL, NULL,                                    0, "<Separator>"},
	{"/Delete",        "",   GTK_SIGNAL_FUNC(delete_selection),       0, NULL},
	{"/Rename",        "",   GTK_SIGNAL_FUNC(rename_selection),       0, NULL},
	{"/New directory", "",   GTK_SIGNAL_FUNC(make_new_dir),           0, NULL},
};

GtkWidget *NewMenuBar (GtkWidget *window)
{
	GtkItemFactory *item_factory;
	GtkAccelGroup *groep;
	GtkWidget *widget;
	gint number_entries = sizeof(menu_items)/sizeof(menu_items[0]);
	groep = gtk_accel_group_new ();
	item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", groep);
	gtk_item_factory_create_items (item_factory, number_entries, menu_items, NULL);
	gtk_window_add_accel_group (GTK_WINDOW (window), groep);
	widget = gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_widget_show (widget);
	return widget;
}

GtkWidget *NewDirPopup (GtkWidget *window)
{
	GtkItemFactory *item_factory;
	GtkWidget *widget;
	gint number_entries  = sizeof(popup_items)/sizeof(popup_items[0]);
	item_factory = gtk_item_factory_new (GTK_TYPE_MENU, "<lijst>", NULL);
	gtk_item_factory_create_items (item_factory, number_entries, popup_items, NULL);
	widget = gtk_item_factory_get_widget (item_factory, "<lijst>");
	gtk_widget_show (widget);
	return widget;
}
