#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <gtk/gtk.h>
#include <stdio.h>

extern char *completename      (char *path, char *filename);
extern char *dir_parent_dir    (char *dir, char **rest);

extern int   file_exists       (char *path); 
extern int   dir_has_subdirs   (char *path);
extern int   is_a_dir          (char *url);
extern int   dir_is_empty      (char *dirnaam);

char *completename (char *path, char *filename)
{
	char *kindnaam;
	kindnaam = (char *) malloc (strlen(path)+strlen(filename)+16);
	memset(kindnaam,0,strlen(path)+strlen(filename)+16);
	strcpy (kindnaam,path);
	if ((path[strlen(path)-1]) != '/') strcat (kindnaam,"/");
	strcat (kindnaam,filename);
	return kindnaam;
}

int dir_has_subdirs (char *path)
{
	DIR *dirdes;
	struct dirent *inhoud;
	struct stat buf;

	dirdes=opendir(path);
	if (dirdes==NULL) return FALSE;
	chdir (path);
	while((inhoud=readdir(dirdes)) !=NULL) {
		stat(inhoud->d_name, &buf);
		if (S_ISDIR(buf.st_mode)
				&& (strcmp (inhoud->d_name,".")!=0)
				&& (strcmp (inhoud->d_name,"..")!=0)) {
			closedir (dirdes);
			return TRUE;
		}
	}
	closedir (dirdes);
	return FALSE;
}

/* 
 * this routine separates a dir in two parts it allocates a new 
 * string for both the return value and the "rest" part 
 */
char *dir_parent_dir (char *dir, char **rest)
{
	gboolean have_rest = FALSE;
	int i;
	char *parent;

	parent = strdup (dir);
	for (i=strlen(parent);i>0;i--) {
		if (parent[i] == '/' && have_rest == TRUE) {
			*rest = strdup (parent+i+1);
			parent [i] = 0;
			return parent;
		} else if (parent[i] =='/') {
			have_rest = FALSE;
		} else {
			have_rest = TRUE;
		}
	}
	free (parent);
	return NULL;
}

int is_a_dir(char *url)
{
	struct stat buf;
	if (url == NULL) return FALSE;
	stat (url, &buf);
	if (S_ISDIR(buf.st_mode)) return TRUE;
	return FALSE;
}

int dir_is_empty (char *dirnaam)
{
	DIR *dirdes;
	struct dirent *inhoud;
	inhoud = (struct dirent *) malloc (sizeof (struct dirent));
	dirdes=opendir ((char*)dirnaam);
	if (dirdes == NULL) {
		printf ("error 666 occured: dir could not be opened, it was %s\n", (char *)dirnaam);
		return FALSE;
	}
	while ((inhoud=readdir(dirdes))!=NULL) {
		if (strcmp (inhoud->d_name ,".") && strcmp(inhoud->d_name, "..")) return FALSE;
	}
	return TRUE;
}

int file_exists (char *path)
{
	struct stat buf;

	if (stat (path,&buf) == -1)
		return TRUE;
	return FALSE;
}
