#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "filesys.h"
#include "../std_dialog.h"
#include "../lowlevel.h"
#include "../tree.h"

extern int rename_file (gchar *source, gchar *destination);
extern int rename_multiple_files (struct multiple_file_ops *files);
int local_rename_file (gchar *source, gchar *destination);

int rename_multiple_files (struct multiple_file_ops *files)
{
	struct multiple_file_ops *tmp;
	int return_value = TRUE;

	tmp = files;
	while(tmp) {
		if (local_rename_file (tmp->source, tmp->destination) == FALSE)
			return_value = FALSE;
		tmp = tmp->next;
	}
	if (return_value == FALSE)
		message ("Renaming file(s) failed");
	return return_value;
}

int rename_file (gchar *source, gchar *destination)
{
	if (local_rename_file(source, destination) == FALSE) {
		message ("The computer could not rename the file");
		return FALSE;
	}	
	return TRUE;
}

int local_rename_file (gchar *source, gchar *destination)
{
	int return_value;
	if (strcmp (source, destination) == 0) return TRUE;
	errno = 0;
	return_value = rename(source, destination);
	if (return_value == 0) {
		if (is_a_dir (destination)) {
			tree_remove_dir (source);
			tree_add_dir (destination, TRUE);
		}
		return TRUE;
	}
	if (errno == EXDEV) {
		return_value = copy_file (source, destination);
		if (return_value == TRUE) {
			delete_url (source);
			/* should interactively tell what's goin on */
			return TRUE;
		}
	}
	return FALSE;
}
