#include <gtk/gtk.h>
#include <sys/stat.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>

#include "../tree.h"
#include "../lowlevel.h"
#include "../std_dialog.h"
#include "filesys.h"

extern int delete_url (char *url);
extern int delete_multiple_urls (GSList *urls);

int local_delete_url (char *url, struct info_flags *options);
int delete_file (char *name, struct info_flags *options);
int delete_dir (char *dirname, struct info_flags *options);

static char *choices[] = {"Yes", "No", "Yes to all", "Abort"};

int delete_multiple_urls (GSList *urls)
{
	struct info_flags options;
	GSList *iterator;
	int i=0;

	options.abort_flag = FALSE;
	options.all_yes_flag = FALSE;
	iterator = urls;
	while (iterator) {
		if (local_delete_url (iterator->data, &options) == FALSE)
			i++;
		iterator = iterator->next;
	}
	if (i>0) {
		message ("Deleting items failed");
		return FALSE;
	}
	return TRUE;
}

int delete_url (char *url)
{
	struct info_flags options;
	options.abort_flag = FALSE;
	options.all_yes_flag = FALSE;

	if (local_delete_url (url, &options) == FALSE) {
		message ("Deleting failed");
		return FALSE;
	}
	return TRUE;
}

int local_delete_url (char *url, struct info_flags *options)
{
	struct stat buf;
	int return_value;

	if (options->abort_flag == TRUE) return FALSE;
	stat (url, &buf);
	if (S_ISDIR(buf.st_mode)) return_value = delete_dir (url, options);
	else return_value = delete_file (url,options);

	return return_value;
			
}

int delete_file (char *name, struct info_flags *options)
{
	return (!unlink (name));
}

int delete_dir (char *dirname, struct info_flags *options)
{
	DIR *dirdes;
	struct dirent *inhoud;
	int j;
	char *realurl, *messagestring;

	
	if (!strcmp(dirname,".") || !strcmp(dirname,"..")) {
		message ("Sorry, I cannot remove the directories . or ..");
		
	} else if (!dir_is_empty(dirname)) {
		
		if (options->all_yes_flag == TRUE) {
			j=1;
		} else {
			messagestring = (gchar *)malloc (sizeof (char) *( strlen(dirname) + 70)); 
			sprintf (messagestring, "Directory %s is not empty. Do you really want to delete it", dirname);
			j= question (messagestring, 4, choices);
			free (messagestring);
		}
		switch (j) {
		case 0: 					/* no as well */
		case 2: 					/* no */
			break; 
		case 3: 					/* yes to all */
			options->all_yes_flag = TRUE;
		case 1: 					/* yes */
			chdir (dirname);
			dirdes = opendir (dirname);
			if (dirdes == NULL ) {
				printf ("error 3/4 : dir not opened %s\n",dirname);
				return FALSE ;
			}
			while ((inhoud = readdir(dirdes))!=NULL) {
				if (strcmp (inhoud->d_name ,".") && strcmp(inhoud->d_name, "..")) { 
					if (chdir (dirname) == -1) return FALSE;
					realurl = completename (dirname, inhoud->d_name);
					local_delete_url(realurl, options);
					free (realurl);
				}
			}
			closedir (dirdes);
			if (rmdir (dirname) == -1) {
				return FALSE;
			}
			tree_remove_dir (dirname);
			
			break;
		case 4: 					/* abort */
			options->abort_flag = TRUE;
			break;
		}
		
	} else {
		if (rmdir (dirname) == -1) {
			 return FALSE;
		}
		tree_remove_dir (dirname);
	}
	return TRUE;
}
