
/*
* bs.c
* simple button shell for X11
* Luiz Henrique de Figueiredo (lhf@visgraf.impa.br)
* 05 Nov 92
*/

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

typedef void Callback(Widget w, caddr_t client_data, caddr_t call_data);

void	doargs		(int argc, char* argv[]);
void	makemenu	(void);
void	execute		(char* s);
Widget	addlabel	(char* label);
Widget	addbutton	(char* label, Callback* f, char* p);
void	do_it		(Widget w, caddr_t client_data, caddr_t call_data);
void	do_quit		(Widget w, caddr_t client_data, caddr_t call_data);

static	Widget		toplevel;
static	Widget		form;
static	Widget		wh=NULL;
static	Widget		wv=NULL;
static	FILE*		shell;
static	char*		param=NULL;

#define	getline(s)	fgets(s,sizeof(s),stdin)

int main(int argc, char* argv[])
{
 shell=popen("/bin/sh","w");
 doargs(argc,argv);
 makemenu();
 XtRealizeWidget(toplevel);
 XtMainLoop();
 return 0;
}

void doargs(int argc, char* argv[])
{
 char* f;
 /* do Xaw/Xt initialization first */
 toplevel=XtInitialize(argv[0],"bs",NULL,0,&argc,argv);
 switch (argc)
 {
  case 1:
   f=".bsrc";	/* default menu file to open in current dir */
   break;
  case 2:
   f=argv[1];	/* named menu file to open */
   break;
  case 3:
   f=argv[1];	/* named  menu file to open */
   param=argv[2];	/* passed param always requires named menu file */
   break;
  default:
   fprintf(stderr,"usage: bs [X toolkit options] [menu-file] [parameter]\n");
   exit(1);
 }
 if (freopen(f,"r",stdin)==NULL)
 {
  fprintf(stderr,"bs: cannot open ");
  perror(f);
  exit(1);
 }
}

void makemenu(void)
{
  char* t;
  char s[BUFSIZ];
  if (param) {	/* 'param' set to argv[2] */
	char sb[BUFSIZ];
	sprintf(sb,"F=%s\n",param);
//    printf ("sb:%sX\n",(sb));
	execute(sb);	/* pass argv[2] as string variable '$F' */
  }
  form=XtCreateManagedWidget("form",formWidgetClass,toplevel,NULL,0);
  while (getline(s))	/* #define getline(s) fgets(s,sizeof(s),stdin) */
  {
	if (*s=='\n')		/* empty line: stack vertical */
	{
	  if (wh!=NULL)
	  {
		wv=wh;
		wh=NULL;
	  }
	  continue;
	}
	t=strchr(s,'\t');
	if (t==NULL)		/* no tab means empty command: label */
	  wh=addlabel(s);
	else if (t==s)		/* empty label: prolog code */
	  execute(s);		/* so execute it while loading */
	else
	{
	  *t++=0;	/* overwrite tab char with \0 */
	  wh=addbutton(s,do_it,t); /* label 's', callback 'doit', command string 't' */
	}
  }
  addbutton("Cancel",do_quit,NULL);
}

void execute(char* s)
{
 fputs(s,shell);
 fflush(shell);
}

Widget addlabel(char* label)
{
 Widget w=XtVaCreateManagedWidget(label,labelWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	XtNborderWidth,	(XtArgVal) 0,
	NULL);
 return w;
}

Widget addbutton(char* label, Callback* f, char* p)
{
 Widget w=XtVaCreateManagedWidget(label,commandWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	NULL);
 XtAddCallback(w,XtNcallback,(XtCallbackProc) f,XtNewString(p));
 return w;
}

void do_it(Widget w, caddr_t client_data, caddr_t call_data)
{
// printf ("t:%s",(client_data));
 execute(client_data);
 pclose(shell);
 exit(0);
}

void do_quit(Widget w, caddr_t client_data, caddr_t call_data)
{
 pclose(shell);
 exit(0);
}
