
/***************************************************************************
 *
 * $Header: hex.c
 *
 * View-Hex-Kommando-Bearbeitung
 *
 ***************************************************************************/

#include "txplor.h"

static int ViewHexFile(char *file_path);

int
ViewHex(char *file_path)
{
	switch (mode) {
	case DISK_MODE:
	case USER_MODE:
		return (ViewHexFile(file_path));
	case TAPE_MODE:
	default:
//		beep();
		return (-1);
	}
}

static int
ViewHexFile(char *file_path)
{
	char *command_line;
	int result = -1;

	if (access(file_path, R_OK)) {
		(void) sprintf(message,
					   "HexView not possible!*\"%s\"*%s",
					   file_path, strerror(errno));
		MESSAGE(message);
		ESCAPE;
	}

	if ((command_line = (char *) malloc(COMMAND_LINE_LENGTH + 1)) == NULL) {
		ERROR_MSG("Malloc failed*ABORT");
		exit(1);
	}

	{
		(void) sprintf(command_line, "%s '%s' | %s", HEXDUMP, file_path, PAGER);
	}

	if ((result = SystemCall(command_line))) {
		(void) sprintf(message, "can't execute*%s", command_line);
		MESSAGE(message);
	}

	free(command_line);

  FNC_XIT:

	return (result);
}
