
/***************************************************************************
 *
 * $Header: execute.c
 *
 * Ausfuehren von System-Kommandos
 *
 ***************************************************************************/

#include "txplor.h"

extern int chdir(const char *);

int
Execute(DirEntry * dir_entry, FileEntry * file_entry, int doquery)
{
	char cwd[PATH_LENGTH + 1];
	char path[PATH_LENGTH + 1];
	int result;
	char command_line[COMMAND_LINE_LENGTH + 1] = "";

	result = -1;

	if (file_entry) {
		if (!(file_entry->stat_struct.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH))) {
			(void) strcpy(command_line, "x ");
		}
		(void) strcat(command_line, file_entry->name);
	}

	MvAddStr(LINES - 2, 1, "Command:");
	if (doquery)
		result = !GetCommandLine(command_line);
	else
		result = 1;
	if (result) {
		if (getcwd(cwd, PATH_LENGTH) == NULL) {
			WARNING("getcwd failed*\".\"assumed");
			(void) strcpy(cwd, ".");
		}

		if (mode == DISK_MODE || mode == USER_MODE) {
			if (chdir(GetPath(dir_entry, path))) {
				(void) sprintf(message, "Can't change directory to*\"%s\"", path);
				MESSAGE(message);
			} else {
				refresh();
				result = SilentSystemCall(command_line);
			}
			(void) chdir(cwd);
		} else {
			refresh();
			result = SilentSystemCall(command_line);
		}
	}

	return (result);
}

int
GetCommandLine(char *command_line)
{
	int result;

	result = -1;

	ClearHelp();

	MvAddStr(LINES - 2, 1, "Command: ");
	if (InputString(command_line, LINES - 2, 10, COLS - 11, "\r\033") == CR) {
		move(LINES - 2, 1);
		clrtoeol();
		result = 0;
	}

	move(LINES - 2, 1);
	clrtoeol();

	return (result);
}

int
ExecuteCommand(FileEntry * fe_ptr, WalkingPackage * walking_package)
{
	char command_line[COMMAND_LINE_LENGTH + 1];
	int i, result;
	char c;
	char *cptr;

	command_line[0] = '\0';
	cptr = command_line;

	walking_package->new_fe_ptr = fe_ptr;	/* unchanged */

	for (i = 0; (c = walking_package->function_data.execute.command[i]); i++) {
		if (c == '{'
			&& walking_package->function_data.execute.command[i + 1] == '}') {
			(void) GetFileNamePath(fe_ptr, cptr);
			cptr = &command_line[strlen(command_line)];
			i++;
		} else {
			*cptr++ = c;
		}
	}
	*cptr = '\0';

	result = SilentSystemCall(command_line);

	/* Ignore Result */
  /*---------------*/

	result = 0;

	return (result);
}
