#! /usr/bin/perl
# retawq/tool/birtcfg.pl - generate a built-in run-time configuration
# This file is part of retawq (<http://retawq.sourceforge.net/>), a network
# client created by Arne Thomassen; retawq is basically released under certain
# versions of the GNU General Public License and WITHOUT ANY WARRANTY.
# Read the file COPYING for license details, README for program information.
# Copyright (C) 2004-2005 Arne Thomassen <arne@arne-thomassen.de>

# This Perl script prepares a built-in run-time configuration from a file.
# For documentation, see e.g. docu/ctconfig.html, OPTION_BIRTCFG.

if ( ($0 ne 'tool/birtcfg.pl') or ($#ARGV != 0) )
{ die "Usage: \"tool/birtcfg.pl FILENAME\""; }

my $filename = $ARGV[0];
if (!open(IN, $filename)) { die "Can't read file \"$filename\""; }
my @lines = ();
while (my $line = <IN>)
{ if ($line =~ m/\"/) { die "File contains a double-quote character (\")"; }
  push(@lines, $line);
}

# No error occurred, so we try to write the results:
if (!open(OUT, ">birtcfg.inc")) { die "Can't create output file \"birtcfg.inc\""; }
print OUT "/* birtcfg.inc - auto-generated by tool/birtcfg.pl */
const char strBirtcfg[] =
\"", @lines, "\";\n";
close(OUT);
print "Successfully generated birtcfg.inc from \"$filename\".\n";
exit(0);
