
// xbr.h for duuumb xlib only curses clone. replaces #include <curses.h>

/* xbr.h Copyright (C) March 3, 2004, Terry Loveall <loveall@qwest.net>
This program is released into the public domain.

THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY OR BINARIES. COMPILE AND USE 
AT YOUR OWN RISK.
*/
#include <X11/keysymdef.h>
#include <stdarg.h>

#define ERR     (-1)
#define OK      (0)
#define TRUE    (1)
#define FALSE   (0)
//#define EOF     (-1)
#define A_CHARTEXT     0xFF
#define A_NORMAL        0x0
#define A_DIM           0x0
#define A_REVERSE       0x1 << 8
#define B_REVERSE       0x1
#define A_UNDERLINE     0x2 << 8
#define B_UNDERLINE     0x2
#define A_BOLD          0x4 << 8
#define B_BOLD          0x4
#define A_BLINK         0x7 << 8
#define B_BLINK         0x7

#define COLOR_BLACK		0
#define COLOR_RED		1
#define COLOR_GREEN		2
#define COLOR_YELLOW	3	
#define COLOR_BLUE		4
#define COLOR_MAGENTA	5	
#define COLOR_CYAN		6
#define COLOR_WHITE		7
#define COLOR_GRAY		8

#define COLOR_PAIRS 32

#define COLS screen_width-1
#define LINES screen_height
#define BUTTON1_CLICKED 1
#define BUTTON2_CLICKED 2
#define BUTTON3_CLICKED 3

// curses replacement defs:

#define KEY_MOUSE  0x21b
#define KEY_RESIZE 0x222
#define KEY_BACKSPACE 0xff08
#define KEY_DEL 0x0007
#define KEY_END 0xff57
#define KEY_ENTER 0xff0d
#define KEY_ESCAPE 0xff1b
#define KEY_META 0xffe9
#define KEY_HOME 0xff50
#define KEY_NPAGE 0xff56
#define KEY_PPAGE 0xff55
#define KEY_LEFT 0xff51
#define KEY_UP 0xff52
#define KEY_RIGHT 0xff53
#define KEY_DOWN 0xff54
#define KEY_HELP 0xffbe
#define KEY_CANCEL 0xFF69
#define KEY_TAB 0xFF09
#define KEY_BTAB 0xFe20
#define KEY_IC 0xFF63
#define KEY_DC 0x07
#define KEY_REFRESH 0x0012

#define KEY_A1 KEY_HOME
#define KEY_C1 KEY_END
#define KEY_F0 0xffbd
#define KEY_F(n) (KEY_F0+(n))

#if 1
#ifndef ACS_ULCORNER
#define ACS_ULCORNER 0x0d
//#define ACS_ULCORNER 'M' 0d
#endif
#ifndef ACS_URCORNER
#define ACS_URCORNER 0x0c
//#define ACS_URCORNER 'L' 0c
#endif
#ifndef ACS_LLCORNER
#define ACS_LLCORNER 0x0e
//#define ACS_LLCORNER 'N' 0e
#endif
#ifndef ACS_LRCORNER
#define ACS_LRCORNER 0x0b
//#define ACS_LRCORNER 'K' 0b
#endif
#ifndef ACS_VLINE
#define ACS_VLINE    0x19
//#define ACS_VLINE    'Y' 19
#endif
#ifndef ACS_HLINE
#define ACS_HLINE    0x12
//#define ACS_HLINE    'R' 12
#endif
#ifndef ACS_RTEE
#define ACS_RTEE    0x16
//#define ACS_RTEE    'V' 16
#endif
#ifndef ACS_LTEE
#define ACS_LTEE    0x15
//#define ACS_LTEE    'U' 15
#endif
#ifndef ACS_BTEE
#define ACS_BTEE    0x17
//#define ACS_BTEE    'W' 17
#endif
#ifndef ACS_TTEE
#define ACS_TTEE    0x18
//#define ACS_TTEE    'X' 18
#endif
#ifndef ACS_PLUS
#define ACS_PLUS    0x0f
//#define ACS_PLUS    'O' 0f
#endif
#ifndef ACS_BLOCK
#define ACS_BLOCK   '?'
#endif
#ifndef ACS_LARROW
#define ACS_LARROW  '<'
#endif

#else

#ifndef ACS_ULCORNER
#define ACS_ULCORNER ('+'|0x80)
#endif
#ifndef ACS_URCORNER
#define ACS_URCORNER ('+'|0x80)
#endif
#ifndef ACS_LLCORNER
#define ACS_LLCORNER ('+'|0x80)
#endif
#ifndef ACS_LRCORNER
#define ACS_LRCORNER ('+'|0x80)
#endif
#ifndef ACS_VLINE
#define ACS_VLINE    ('|'|0x80)
#endif
#ifndef ACS_HLINE
#define ACS_HLINE    ('-'|0x80)
#endif
#ifndef ACS_RTEE
#define ACS_RTEE    ('+'|0x80)
#endif
#ifndef ACS_LTEE
#define ACS_LTEE    ('+'|0x80)
#endif
#ifndef ACS_BTEE
#define ACS_BTEE    ('+'|0x80)
#endif
#ifndef ACS_TTEE
#define ACS_TTEE    ('+'|0x80)
#endif
#ifndef ACS_PLUS
#define ACS_PLUS    ('+'|0x80)
#endif
#ifndef ACS_BLOCK
#define ACS_BLOCK   ('?'|0x80)
#endif
#ifndef ACS_LARROW
#define ACS_LARROW  ('<'|0x80)
#endif
#endif // 0
#define A_ATTRIBUTES    0xFFFFFF00L

typedef unsigned long chtype;
typedef chtype attr_t;
typedef struct WINDOW
{
        int _cury, _curx;		/* current cursor position */
        int nlines, ncols;		/* height, width */
        int begin_y, begin_x;	/* upper left y,x */
        int num;				/* sequential number of created window */
        struct WINDOW *prev;	/* prev window written to */
} WINDOW;

typedef struct
{
        int x;           /* absolute column, 0 based, measured in characters */
        int y;           /* absolute row, 0 based, measured in characters */
        int button;      /* Xlib button state */
        int changes;     /* holds prev _different_ button */
} MOUSE_STATUS;

// externs data defs here
extern int display_start;	// xbr vbar thumb position
extern int total_linec;		// xbr vbar total span
extern int display_pos;	// xbr vbar display position reference
extern int scroll_height;	// xbr vbar scroll window height
extern int scroll_width;	// xbr vbar scroll window width

extern MOUSE_STATUS last_click;
extern WINDOW *stdscr;
#define  cursorp_x stdscr->_curx
#define  cursorp_y stdscr->_cury
extern int screen_width;
extern int screen_height;
#define COLOR_PAIR(x) ((x) << 11)

// extern func proto here
//extern void handle_command_code(int);
//extern void window_redraw_all();
extern void set_title(char *str);
extern int exec_main(int argc,char *argv[]);
extern void nop(void);
extern void cbreak(void);
extern void nonl(void);
extern void intrflush(void *, int);
extern void keypad(void *, int);
extern void nodelay(void *, int);
extern void echo(void);
extern void noecho(void);
extern void echo(void);
extern void raw(void);
extern void noraw(void);
extern void scrollok(void *, int);
extern void meta(void * p, int fl);
extern void endwin(void);
extern int initscr(void);
extern void beep(void);

extern int move(int, int);
extern int wmove(WINDOW *w, int, int);
extern int init_pair(short p, short fg, short bg);

extern void attrset(int);
extern void attron(int);
extern void attroff(int);

extern int inch(void);
extern int mvinch(int y, int x);

extern int addch(int);
extern void addnstr(char *s, int n);
extern void addstr(char *s);
extern void waddstr(WINDOW *w, char *s);

extern int waddch(WINDOW *w, int c);
extern void mvaddch(int, int, int);
extern void mvaddnstr(int y, int x, char *s, int n);
extern void mvaddstr(int y, int x, char *s);

extern void wprintw(WINDOW *, const char *, ...);
extern void mvwprintw(WINDOW *, int, int, const char *, ...);
extern void vwprintw(WINDOW *, const char *, va_list);

extern void scroll(WINDOW * w);

extern void clrtoeol(void);
extern void clrtobot(void);
extern void clear(void);
extern void erase(void);
extern void refresh(void);

extern int getCh(int);
extern char* getstr(char *s);
extern void sys_exit(int);

extern void redraw();
extern void unredraw();

extern WINDOW *newwin(int nlines, int ncols, int begin_y, int begin_x);
extern void delwin(WINDOW *win);
extern void def_prog_mode(void);
extern void reset_prog_mode(void);
extern void wclrtoeol(WINDOW *w);
extern void werase(WINDOW *w);
extern void box(WINDOW *w, int v, int h);
extern void winsertln(WINDOW *w);

extern void mvwaddstr(WINDOW *w, int y, int x, char *s);
extern void wbkgdset(WINDOW *win, const chtype ch);
extern void wattrset(WINDOW *win, int attrs);
extern void mvwin(WINDOW *win, int y, int x);
extern void delwin(WINDOW *win);
extern void wclrtoeol(WINDOW *w);
extern void def_prog_mode(void);
extern void reset_prog_mode(void);
extern void show_vbar(void);
extern void send_key(int c);

extern int COLORS;
extern int has_colors();

#define wclear(w) clear()
#define timeout(p) nop()
#define getch() getCh(0)
#define wgetch(win) getch()
#define erasechar() KEY_BACKSPACE
#define doupdate() nop()
#define redrawwin(win) nop()
#define wnoutrefresh(win) nop()
#define wrefresh(win) nop()
#define wattron(w,c) attron(c)
#define wattroff(w,c) attroff(c)
#define getayx(y, x) { y = cursorp_y; x = cursorp_x; }
#define getyx(w, y, x) { y = cursorp_y - w->begin_y; x = cursorp_x - w->begin_x; }
#define getbegyx(w, y, x) { y = w->begin_y; x = w->begin_x; }
#define getmaxyx(w, y, x) { y = w->nlines; x = w->ncols;}

// txplor defs
#define wattrset( win, attr ) attrset(attr)
#define vidattr( attr ) attrset(attr)
#define curs_set(x) x - x
#define putp(s) addstr(s)
#define echochar(ch) addch(ch)
#define mvprintw(y,x,s) mvaddstr(y,x,s)
#define clearok(w,f) nop()
#define leaveok {}
#define typeahead(fd) {}
#define baudrate() QUICK_BAUD_RATE
#define subwin(w,nl,nc,y,x) newwin(nl,nc,y,x)
#define winsertln(w) {}
#define touchwin(w) nop()
#define start_color() {}
// done xcurses
