
/* xbr.c Copyright (C) March 3, 2004, Terry Loveall <loveall@qwest.net>
This program is released into the public domain.

THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY OR BINARIES. COMPILE AND USE 
AT YOUR OWN RISK.
*/

// DOGTK compiles with gtk/glib wrapper for embedding within other GTK apps
// defined in Makefile
#ifndef DOGTK
#define VERSION "0.12"
#else //DOGTK
#define VERSION "Gtk .12"
#endif //DOGTK

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <ctype.h>
#include <signal.h>
#include <pwd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#define  XK_MISCELLANY
#include <X11/keysymdef.h>
#ifdef DOGTK
#include <gtk/gtk.h>
#include <gtk/gtksocket.h>
#include <gdk/gdkx.h>
#endif //DOGTK
#include "xbr.h"

#define DEFAULT_WIDTH 104
#define DEFAULT_HEIGHT 30

//compile options: comment out to disable associated features

// VERTCURS for a vertical cursor, underline otherwise
#define VERTCURS

// TWOBUTN paste with button3 click, set selection with button3 drag
// for those of us who only have tws button mice
#define TWOBUTN

// MINIMAL if defined, disables global shared dir /usr/share/edx and
// rc file edxrc
#define MINIMAL

// THREED enable 3D scrollbar or if commented out, xbr builds on 1diskwin
//#define THREED

// black char on linen, red cursor, black on grey high-lights
char *FgColor="Black", *BgColor="Linen", *CrColor="Red", *HiFgColor="Black", *HiBgColor="Grey75";

// medium font for black on linen best presentation
#ifndef THREED
#define FONTNAME "fixed"
#define BFONTNAME "7x14"
#else
#define FONTNAME	"-b&h-lucidatypewriter-medium-r-normal-sans-12-*-*-*-m-70-iso8859-1"
#define BFONTNAME	"-b&h-lucidatypewriter-bold-r-normal-sans-12-*-*-*-m-70-iso8859-1"
#endif // THREED

// turns on display of keypressed event values in upper right corner
//#define DEBUG

#define AMAX	0xD0000 	// main buffer size
#define BMAX	0x10000 	// block size
#define YTOP	0			// first line

#define EOL '\0'	// end of line marker
#define BLNK	' ' // blank
#define LF	'\n'	// new line
#define NLEN	256 // input buffer length
#define XINC	20	// increment for x offset

#define CHG 0	/* file Modified: =0 file not changed, !=0 file changed */
#define FIL 1	/* Fill */
#define OVR 2	/* character insert=0, Overwrite=1 */
#define CAS 3	/* Case sensitive: =0 no, !=0 yes */
#define TAB 4	/* Tab expand */
#define BLK 5	/* block mark active */

#define IND 6	/* auto indent flag */
#define REC 7	/* recording macro flag */
#define ALL 8	/* replace all flag */
#define WRD 9	/* find wdelims delimited word */
#define SHW 10  /* update & show entire screen */
#define NEW 11	/* editing a new file */
#define WIN 12	/* window: <0 same win, =0 load new */

/* character handler types */
static enum {
	MAIN,
	DIALOG,
	OPTIONS
} executive = MAIN; 	/* default character handler */

/* X related globals */
#ifdef DOGTK
GtkWidget *main_win;
guint32 xid = 0;
#endif //DOGTK

int screen;
Display *dpy;
Window win;
GC gc;
XFontStruct *font;
XFontStruct *bfont;
XEvent xevent;
XKeyEvent *keve;
Time eve_time;
char *selection_text;	/* selected text for X clipboard */
int selection_length;
int do_background = 1;	/* run in background flag */
int gargc;
char **gargv;
int Width, Height;
int fwidth, fheight;	/* font character width, height */
int BWidth, BHeight;
int bfwidth, bfheight;	/* font character width, height */

/* Foreground, Background normal and highlight colores */
XColor FgXColor, BgXColor, CrXColor, HiFgXColor, HiBgXColor;

int COLORS = 8;
//Colormap colormap;
unsigned int pixel_fg, pixel_bg, pixel_black, pixel_white;
unsigned long colors[2*COLOR_PAIRS];

int HiLo;			/* hightlight status, 0=off */
Atom DeleteWindow;		/* Atom of delete window message */

char *FontName=NULL;
char *BFontName=NULL;
char *DisplayName=NULL;
char *AppName;
char *RcFile = NULL;

char Command[NLEN] = "fsx  ";
char *cfdpath;

char *Geometry=NULL;
/* maximum viewable 6x8 chars on a 2000x1600 screen */
#define MAXWLINE 2048
#define MAXVLINE 250
char eolbuf[MAXWLINE];	/* holds spaces for clreol(), 450 is 2000x1600 */

char dispbuf[MAXWLINE * MAXVLINE];	// display char buffer
char attrbuf[MAXWLINE * MAXVLINE];	// display char attribute buffer
int current_attr = 0;

#define CNORM 0
#define CBOLD 1
#define CINVR 2
#define CUNDR 4

/* func prototypes */

void sys_exit(int code);
void gotoxy(int horz,int vert);
void cursor_draw(unsigned long color);
void draw_cursor();
void undraw_cursor();
void drawstring(char *str, int len);
void cputs(char *prntstr);
int putch(char chr);
void clreol();
void normalvideo();
void boldvideo();
void highvideo();
void lowvideo();
void clrscr();
void bell();
void mark_off();
void update();
int scroll_text(int ycur);
void show_vbar();
void child_sig_handler(int signal);
void sig_handler(int);
void font_height(void);
int paste_primary(int win, int property, int Delete);
int request_selection(int time);
char *mrealloc(char *s, int len);
void set_selection();
void send_selection(XSelectionRequestEvent * rq);
void init(int argc,char *argv[]);
int handle_xkey(char *astr, int skey, int state);
void do_paste();
void do_select(int delete);
int main(int argc,char *argv[]);

#define EDIT "OXElmo"
#ifndef MINIMAL
#define SHARE_DIR "/usr/share/edx"
#define DEFAULT_RC "edxrc"
#endif /* MINIMAL */

// global defs
int done = 0;
int eolx;					/* coord of eol */
int update_scr = 1; 		/* do screen updates flag */

char *bstart, *bend; 		/* marked block start, end and char pointer */
char *binding[26];

unsigned char *paste_text;	// paste data pointer, NULL if empty
int paste_cnt = 0, paste_i;	// limit and index

#define YTOP	0		/* first line */

char  bbuf[NLEN]; 			  /* temp file name */
char  sbuf[NLEN], rbuf[NLEN]; /* search buffer, replace buffer */
char  *s;					  /* pointer to search string */
int	rlen, slen;			  /* replace and search lengths */

unsigned blen;				  /* length of text in block buffer */
char *cur_pos;
char *line_start;				/* current pos, start of current line */
char *screen_start;				/* global screen start */
unsigned int xlo;				/* x offset for left display edge */
char *last_pos;					/* last last position visited */
char *old_pos;					/* last position visited */

// vbar and scroll_text support
int vtot, vcur, pos, ftheight, thumb_top;

int x_offset;					/* offset of xtru from line_start */
int xtru = 0, ytru = 0; 		/* file position */
int ytot = 0;					/* 0 <= ytru <= ytot */
int yref = 0;					/* y of last button press */

int yy1, y2; 				  /* 1st, 2nd line of window */
int tabsize=4;				  /* tab size */
int doCtrlC = 0;				/* decode next char from ^C function */
int doCtrlK = 0;				/* decode next char from ^K function */
int doCtrlQ = 0;				/* decode next char from ^Q function */
int doCtrlX = 0;				/* decode next char from ^X function */
int doEscap = 0;				/* decode next char from Esc function */
int help_done = 0;
int literal = 0;

int col;						/* width of dialog preset (if any) */
int diastart;					/* start of dialog input field */
int first;						/* first dialog char flag, 0=true */
int dblen;						/* current dialog buffer size */
char *diabuf;					/* dialog buffer pointer */
void (*dialogCB) ();			/* callback pointer */

char  *file_end;		/* end of file */
char  *mk = NULL;		/* mark */
char  *last_mk = NULL;	  /* prev mk position */

/* current window struct */
typedef struct {
	char name[NLEN];
	int jump;
} MWIN;	 /* my window structure */

MWIN  ewin;  /* current window */

struct stat ofstat;				/* edit file stat structure */

FILE  *fi, *fo, *fb;	 		/* file handles for input, output, block */
char  flag[WIN+1]="\0\0\0C\0\0N\0\0"; /* options flag presets */
char	fsym[]="MFOCTBNRAW";	/* Modified,Fill,Overwrite,Case,Tab,Block marked,autoiNdent,Rec, All,Word */

char mdelims[] = "\t ,;+-*=^&|?`()[]{}<>\"\'";
char wdelims[] = "\t ,;+*=^&|?:`()[]{}<>\"\'";
char sdelims[] = "\t >]})";

#define UMAX 0x2000		/* undo level */
unsigned int amax, bmax, umax;  /* main buffer, block size, undo level */

char  *bb;	 	 		/* block buffer */
char  *edbuf;	 	  /* edit buffer */

int funckey;		/* function key flag */
int exitf = 1;	  /* exitf = 0 = exit */

int display_start;	// xbr vbar thumb position
int total_linec;	// xbr vbar total span
int display_pos;	// xbr vbar display position reference
int scroll_height;	// xbr vbar scroll window height
int scroll_width;	// xbr vbar scroll window width

MOUSE_STATUS last_click;	// char xy set by get_cur() for app
WINDOW outxy;	/* cursor coordinates for screen positioning */
WINDOW *stdscr = &outxy;
WINDOW *this_win = &outxy;	/* current active window */
int win_num = 0;			/* number of newwin created windows */
int x=0, screen_width;		/* screen position 1 <= x <= screen_width */
int y=1, screen_height; 	/* screen size 0 <= y <= screen_height */

#define  cursorp_x stdscr->_curx
#define  cursorp_y stdscr->_cury

// prev display char attribut before current attribute
int last_attr;

// noop curses definitions

void cbreak(void){}
void nonl(){}
void intrflush(void * p, int fl){}
void keypad(void * p, int fl){}
void nodelay(void * p, int fl){}
void noecho(){}
void echo(){}
void raw(){}
void noraw(){}
void scrollok(void * p, int fl){}
void meta(void * p, int fl){}
void endwin(){}

int initscr()
{
	return(1);
}

// curses emulator

void nop()
{
}

int has_colors()
{
	return(TRUE);
}

void beep()
{
	XBell(dpy,100);
}

void attrset(int a)
{
	current_attr = a >> 8;
}

void attron(int a)
{
	current_attr |= a >> 8;
}

void attroff(int a)
{
	current_attr &= ~(a >> 8);
}

void link_prev(WINDOW *win)
{
	if((win) && (win != this_win)) {
		win->prev = this_win;
		this_win = win;
	}
}

WINDOW *newwin(int nlines, int ncols, int begin_y, int begin_x)
{
	WINDOW *w = (WINDOW *) malloc(sizeof(WINDOW));
	w->_cury = 0;w->_curx = 0;
	w->nlines = nlines;w->ncols = ncols;
	w->begin_y = begin_y;w->begin_x = begin_x;
	w->prev = w;
	w->num = ++win_num;
	return(w);
}

void delwin(WINDOW *win)
{
	if(win) free(win);
}

void wbkgdset(WINDOW *win, const chtype ch)
{
	current_attr = ch >> 8;
}

#define TABSZ 8
#define TABM TABSZ-1

int move(int y, int x)
{
	cursorp_x = x;
	cursorp_y = y;
	if(cursorp_y < 0) cursorp_y = 0;
	if(cursorp_y > screen_height) cursorp_y = screen_height;
	if(cursorp_x < 0) cursorp_x = 0;
	if(cursorp_x > screen_width) cursorp_x = screen_width;
	return 0;
}

int wmove(WINDOW *w, int y, int x)
{
	link_prev(w);
	return(move(w->begin_y + y, w->begin_x + x));
}

int inch(void)
{
	int c = 0, coff;
	if(cursorp_y < 0) cursorp_y = 0;
	if(cursorp_y > screen_height) cursorp_y = screen_height;
	if(cursorp_x < 0) cursorp_x = 0;
	if(cursorp_x > screen_width) cursorp_x = screen_width;
	coff = (cursorp_y * MAXWLINE) + cursorp_x;

	c = dispbuf[coff]; // & 0x7f;

	c |= (attrbuf[coff] << 8) & 0xff;

	return(c);
}

int alloc_color(const char* name, unsigned long* pix)
{
	XColor color, dummy;
	if (XAllocNamedColor(dpy, DefaultColormap(dpy,screen), name, &color, &dummy) != 0)
	{
		*pix = color.pixel;
  		return(1);
  	}
	else return(0);
}

static void set_fgbg(unsigned long fg, unsigned long bg)
{
	XSetForeground(dpy, gc, fg);
	XSetBackground(dpy, gc, bg);
}

int init_pair(short p, short fg, short bg)
{
	unsigned long pix = pixel_fg, pix0;
	int l = 0;
	short s;
	const char* name;
dagin:	// twice thru for fg and bg
	s = ( l ? bg : fg );
	switch (s)	{ 
		case COLOR_BLACK: name = "Black"; break;		// #000000 Black
		case COLOR_RED: name = "Red"; break;			// #FF0000 Red
		case COLOR_GREEN: name = "SeaGreen"; break;		// #2E8B57 SeaGrenn
		case COLOR_YELLOW: name = "Yellow"; break;		// #FFFF00 Yellow
		case COLOR_BLUE: name = "Blue"; break;			// #0000FF Blue
		case COLOR_MAGENTA: name = "Magenta"; break;	// #FF00FF Magenta
		case COLOR_CYAN: name = "Cyan"; break;			// #00FFFF Cyan
		case COLOR_WHITE: name = "Linen"; break;		// #FAF0E6 Linen
		case COLOR_GRAY: name = "Grey75"; break;		// #BFBFBF Grey75
		default: goto out; break;
  }
  if (alloc_color(name, &pix0)) pix = pix0;
  out:
  if(2 * p < COLOR_PAIRS) colors[2 * p + l] = pix;
  if(++l == 1) goto dagin;
  return(OK);
}

int mvinch(int y, int x)
{
	cursorp_x = x;
	cursorp_y = y;
	return(inch());
}

void redraw(void)
{
	flag[SHW] = 1;
}

void unredraw(void)
{
	flag[SHW] = 0;
}

void clrtoeol(void)
{
	if(cursorp_y < 0) cursorp_y = 0;
	if(cursorp_y > screen_height) cursorp_y = screen_height;
	if(cursorp_x < 0) cursorp_x = 0;
	if(cursorp_x > screen_width) cursorp_x = screen_width;
	if(cursorp_x < MAXWLINE) {
		int coff = (cursorp_y * MAXWLINE) + cursorp_x;
		memset(&dispbuf[coff], ' ', MAXWLINE - cursorp_x);
		memset(&attrbuf[coff], 0, MAXWLINE - cursorp_x);
	}
}

int addch(int c)
{
	int coff;
	if(cursorp_y < 0) cursorp_y = 0;
	if(cursorp_y > screen_height) cursorp_y = screen_height;
	if(cursorp_x < 0) cursorp_x = 0;
	if(cursorp_x > screen_width) cursorp_x = screen_width;

	if(c == '\b') { if(cursorp_x) --cursorp_x; goto achx; }
	coff = (cursorp_y * MAXWLINE) + cursorp_x;
//	if((flag[BLK]) && (dispbuf[coff] != c)) mark_off();
	dispbuf[coff] = c;
	attrbuf[coff] = c & 0xff00 ? (c & 0xff00) >> 8 : current_attr;

	if(c == '\t') { do{ addch(' '); } while((cursorp_x & (TABM))); }
//	else if(c == '\r') { clrtoeol();cursorp_x = 0;}
	else if(((++cursorp_x) >= MAXWLINE) || (c == '\n'))
	{
		clrtoeol();
		cursorp_x = 0;
		cursorp_y++;
	}
	if(cursorp_y >= screen_height) 
	{
		cursorp_y = screen_height - 1;
	}
	flag[SHW] = 1;
achx:
	return 0;
}

// move & put char with last attron/attroff specified attribute
void mvaddch(int y, int x, int c)
{
	cursorp_x = x;
	cursorp_y = y;
	addch(c);
}

void mvaddnstr(int y, int x, char *s, int n)
{
	int i = 0;
	move(y,x);
	if(n == -1) n=strlen(s);
	while((--n > -1) && s[i]){
		addch(s[i++]);
	}
}

void mvaddstr(int y, int x, char *s)
{
	mvaddnstr( y,  x,  s,  strlen(s));
}

void mvwaddstr(WINDOW *w, int y, int x, char *s)
{
	link_prev(w);
	mvaddstr(w->begin_y + y, w->begin_x + x, s);
}

// put string with last attron/attroff specified attribute of n or less length
void addnstr(char *s, int n)
{
	mvaddnstr( cursorp_y, cursorp_x, s, strlen(s));
}

// put string with last attron/attroff specified attribute
void addstr(char *s)
{
	mvaddstr( cursorp_y, cursorp_x, s);
}

void waddstr(WINDOW *w, char *s)
{
	link_prev(w);
	addstr(s);
}

int waddch(WINDOW *w, int c)
{
	int xl = w->begin_x + w->ncols;
	int yl = w->begin_y + w->nlines;
	link_prev(w);
	if((w->begin_x <= xl) && (w->begin_y <= yl) &&
		(cursorp_x < xl) && (cursorp_y < yl)) {
		addch(c);
		return OK;
	}
	return ERR;
}

void mvwaddch(WINDOW *w, int y, int x, int c)
{
	wmove(w, y, x);
	waddch(w, c);
}

void wclrtoeol(WINDOW *w)
{
	char s[2048];
	int i = 0, y = cursorp_y, x = cursorp_x;
	int l = w->begin_x + w->ncols - cursorp_x;
	link_prev(w);
	while( i < l) s[i++] = ' ';
	s[i] = '\0';
	addstr(s);
	move(y,x);
}

void scroll(WINDOW * w)
{
	int i;
	link_prev(w);
	for(i = w->begin_y + 1; i < w->begin_y + w->nlines - 1;i++) {
		memmove( &dispbuf[(i * MAXWLINE) + w->begin_x + 1], &dispbuf[((i+1) * MAXWLINE) + w->begin_x + 1], w->ncols - 2);
		memmove( &attrbuf[(i * MAXWLINE) + w->begin_x + 1], &attrbuf[((i+1) * MAXWLINE) + w->begin_x + 1], w->ncols - 2);
	}
	memset(&dispbuf[(i * MAXWLINE) + w->begin_x + 1],  ' ', w->ncols - 2);
	memset(&attrbuf[(i * MAXWLINE) + w->begin_x + 1], '\0', w->ncols - 2);
}

void box(WINDOW *w, int v, int h)
{
	int i;
	link_prev(w);
	// draw top line
	move(w->begin_y, w->begin_x);
	addch(ACS_ULCORNER);
	for(i=1;i < w->ncols - 1;i++) addch(ACS_HLINE);
	addch(ACS_URCORNER);
	// draw sides
	for(i = w->begin_y + 1; i < w->begin_y + w->nlines - 1;i++) {
		move(i, w->begin_x); addch(ACS_VLINE);
		move(i, w->begin_x + w->ncols - 1); addch(ACS_VLINE);
	}
	// draw bottom
	move(i, w->begin_x);
	addch(ACS_LLCORNER);
	for(i=1;i < w->ncols - 1;i++) addch(ACS_HLINE);
	addch(ACS_LRCORNER);
}

void werase(WINDOW *w)
{
	int i = 0, y = cursorp_y, x = cursorp_x;
	int l = w->nlines;
	link_prev(w);
	while(i < l) {
		move(w->begin_y + i++, w->begin_x);
		wclrtoeol(w);
	}
	move(y,x);
}

void clrtobot(void)
{
	int xl, fl;
	if(cursorp_y < 0) cursorp_y = 0;
	if(cursorp_y > screen_height) cursorp_y = screen_height;
	if(cursorp_x < 0) cursorp_x = 0;
	if(cursorp_x > screen_width) cursorp_x = screen_width;
	xl = cursorp_x;
	fl = (MAXWLINE * MAXVLINE) - (MAXWLINE * (cursorp_y + 1 < MAXVLINE ? cursorp_y + 1 : MAXVLINE));
	if(xl < MAXWLINE) {
		clrtoeol();
		memset(&dispbuf[MAXWLINE * (cursorp_y + 1)], ' ', fl);
		memset(&attrbuf[MAXWLINE * (cursorp_y + 1)], 0, fl);
	}
}

void erase(void)
{
	cursorp_x = cursorp_y = 0;
	clrtobot();
}

void clear(void)
{
	erase();
	flag[SHW] = 1;
}

void draw_underline(int x, int y)
{
	XFillRectangle(dpy, win, gc,
		(x * fwidth) + 2, (y* fheight) + 1, fwidth-0, 2);
}

void drchr(int offset, int x, int y)
{
	char c[1];
	int tattr, attr = attrbuf[offset];
	c[0] = dispbuf[offset];
//	if(c[0] < ' ') c[0] = ' ';
	// hilite marked text between block-start (bstart) and block-end (bend)
	if((&dispbuf[offset] < bend) && (&dispbuf[offset] >= bstart)) attr ^= B_REVERSE;
	if(last_attr != attr) {
		last_attr = attr;
		if(attr & B_REVERSE) {highvideo();} else {lowvideo() ;}
		if(attr & B_BOLD) {boldvideo();} else {normalvideo() ;}
		if((tattr = (attr >> 3) & 0x1f)) {
			if(attr & B_REVERSE)
				set_fgbg(colors[2 * tattr + 1], colors[2 * tattr]);
			else 
				set_fgbg(colors[2 * tattr], colors[2 * tattr + 1]);
		}
 	}
	XDrawImageString(dpy, win, gc, (x * fwidth) + 2, (y+1) * fheight, &c[0], 1);
	if(attr & B_UNDERLINE) {
		draw_underline(x,y+1);
	}
}

void refresh(void)
{
	int x, y;
	if(!flag[SHW] || paste_text) return;
	undraw_cursor();
	last_attr = -1;
	if(flag[BLK]) {
		if(cur_pos < mk)
			{ bstart = cur_pos; bend = mk; }
		else
			{ bstart = mk; bend = cur_pos; }
	} else bstart = bend = NULL;
	for(y=0; y <= screen_height; y++) {
		int lst = y * MAXWLINE;
		for(x=0; x < screen_width; x++) {
			drchr(lst + x, x, y);
		}
	}
	XFlush(dpy);
	flag[SHW] = 0;
	show_vbar();
	draw_cursor();
}

void
wprintw(WINDOW *win, const char *fmt, ...)
{
	va_list	ap;
	char	*str;

	link_prev(win);
	va_start(ap, fmt);
	vasprintf(&str, fmt, ap);
	va_end(ap);

	waddstr(win, str);
	free(str);
}

void
mvwprintw(WINDOW *win, int y, int x, const char *fmt, ...)
{
	va_list	ap;
	char	*str;

	va_start(ap, fmt);
	vasprintf(&str, fmt, ap);
	va_end(ap);

	mvwaddstr(win, y, x, str);
	free(str);
}

void
vwprintw(WINDOW *win, const char *fmt, va_list ap)
{
	char	*str;

	vasprintf(&str, fmt, ap);
	waddstr(win, str);
	free(str);
}

void
mvwin(WINDOW *win, int y, int x)
{
	link_prev(win);
	win->begin_y = y; win->begin_x = x;
}

void
def_prog_mode(void) {}

void
reset_prog_mode(void) {}

// end of curses emulator

void scr_update()
{
	refresh();
}

// return char address of mouse button click
char *get_cur()
{
	last_click.y = (short)((xevent.xbutton.y-3)/fheight);
	last_click.x = (short)((xevent.xbutton.x < 0 ? 0 : xevent.xbutton.x)/fwidth) + xlo;
	// log button changs
	if(last_click.button != xevent.xbutton.button) last_click.changes = last_click.button;
	last_click.button = xevent.xbutton.button;
	return(&dispbuf[(last_click.y * MAXWLINE) + last_click.x]);
}

void mark_off()
{
	mk = NULL;
	flag[BLK] = 0;
	flag[SHW] = 1;
}

void reset_mark()
{
	if (!last_mk) return;
	flag[BLK] = 1;
	mk = last_mk; 
}

void block_mark()
{
	if( mk == NULL ) {
		mk = get_cur();
		last_mk = mk;
		flag[BLK] = 1;
		flag[SHW] = 1;
	}
	else
		mark_off();
}

char* getstr(char *s)
{
	return s;
}

// go to top of file and reset to known condition
void top()
{
	yy1 = YTOP;
	y2 = YTOP+1;
	line_start = edbuf;
	x_offset = 1;
	xtru = x = 1;
	ytru = y = 0;
	flag[SHW] = 1;
}

void show_flag(int x, int g)
{
	gotoxy(20+x-1,yy1);
	putch(g? fsym[x]: '.');
	flag[x] = g;
}

void show_pos()
{
	char tbuf[NLEN];

	if(executive != MAIN) return;
	highvideo();
	gotoxy(5,yy1);
	sprintf(tbuf,"%d %d	", ytru+1, xtru);
	cputs(tbuf);
}

void show_top()
{
	int i;
	char tbuf[NLEN];

	if(executive != MAIN) return;

	gotoxy(0,yy1);
	highvideo();
	clreol();
//	show_pos();
	for(i=0; i<= SHW-1; i++) show_flag(i, flag[i]);

	sprintf(tbuf,"	%s", cfdpath);
	cputs(tbuf);
	lowvideo();
	gotoxy(x-1,y+y2);
}

void sys_exit(int code)
{
	if(!(flag[CHG])) {
		// watch where you're goin', clean up where you been
		if(selection_text) free(selection_text);
		if(cfdpath) free(cfdpath);
		done = 1;
		exit(code);
	}
	bell();
}

/*
#if 0
  simple minded line input executive for status line dialogs.
  Successful completion, indicated by a Return key, executes the
  callback in dialogCB. Responds to 'Esc' and ^C by terminating
  without executing the callback. Printing first char resets Col.
  Use ^H to overwrite preset string, 'End' displays cursor to EOS.
  All other characters input to diabuf. Set by 'show_gets'.
#endif

void dialog(int key)
{
	int skey;
	skey = key & 0xff;

	gotoxy(diastart+col,yy1);
	undraw_cursor();
	if(keve->state & ControlMask) skey &= 0x1f;
	if(key == XK_End) {
		while((diabuf[col] != 0) && (col < dblen)) putch(diabuf[col++]);
	} else {
		switch(skey){
	 		case 8: {
	 	 		if(col < 0) col = strlen(diabuf);
	 	 		if(col) { col--; outxy._curx--; putch(' '); outxy._curx--;}
	 	 		break;
	 		}
	 		case  3:
	 		case 13:
	 		case 27: {
	 	 		executive = MAIN;
	 	 		diabuf[col] = 0;
	 	 		if(skey == 13) dialogCB(0);
	 	 		flag[SHW] = 1;
	 	 		scr_update();
//	 	 		show_top();
	 	 		break;
	 		}
	 		default: {
	 	 		if(col < 0 || !first) {
	 	 	 		col = 0;
	 	 	 		gotoxy(diastart+col,yy1);
	 	 	 		clreol();
	 	 		}
	 	 		if(col < dblen){
	 	 	 		diabuf[col++] = key;
	 	 	 		putch(key);
	 	 		} else bell();
	 		}
		}
	}
	first = key;
}

//  set editor options executive.
//  Accept a single UPPER or lower case char only from the string "MFOCTBA":
//	Modified, Fill, Overwrite, Case, Tab, Block marked, replace All.

void options(int key)
{
	char *d;
	int k;

	k = toupper(key) & ~0x20;
	if((d=strchr(fsym, k)) != 0) {
		k = d-fsym;
		show_flag(k, !flag[k]);
	}
	executive = MAIN;
	show_top();
	scr_update();
}

// display a dialog property string at fixed location in the status bar

void show_note(char *prp)
{
	gotoxy(29,yy1);
	clreol();
	cputs(prp);
	diastart = outxy._curx+2;
}

// exec the forking cmd
int SYSTEM (char *cmd)
{
	#define SHELL	"/bin/sh"
	pid_t pid;
	switch(pid=fork()) {
		case 0:
			execl(SHELL,"sh","-c",cmd,(char *) 0);
			printf("Execl failed!\n");
			_exit(127);
		case -1: printf("fork error\n");
		default: return(0);
	}
}
*/

/* single char interpreter
void main_exec(int key)
{
	cur_pos = get_cur();
	if(help_done){
		help_done = 0;
		flag[SHW] = 1;
	} else if(literal) {
		key_normal(key);
		literal = 0;
	} else {
		if(funckey ) main_meta(key); else {
	 		if(key >= BLNK)  key_normal(key);
	 		else key_control(key);
		}
	}
	cur_pos = get_cur();

	if(update_scr && exitf && executive == MAIN) scr_update();
}
*/

/******************** Start of cursor I/O ********************/

/* Goto the specified location. */

void gotoxy(int horz,int vert)
{
	outxy._curx = horz;
	outxy._cury = vert;
}

void cursor_draw(unsigned long color)
{
	XSetForeground(dpy, gc, color);
#ifndef VERTCURS
	XFillRectangle(dpy, win, gc,
		(outxy._curx * fwidth) + 2, ((outxy._cury+1)* fheight) + 2, fwidth-1, 2);
#else
	XDrawRectangle(dpy, win, gc,
		(outxy._curx * fwidth) + 2, (outxy._cury * fheight) + 2, 0, fheight);
#endif /* VERTCURS */
	XSetForeground(dpy, gc, HiLo ? HiFgXColor.pixel : FgXColor.pixel);
}

void draw_cursor()
{
	cursor_draw( CrXColor.pixel);
}

void undraw_cursor()
{
	cursor_draw( HiLo ? HiBgXColor.pixel : BgXColor.pixel);
}

void drawstring(char *str, int len)
{
	if (outxy._curx+len>screen_width+1) len = screen_width+1-outxy._curx;
	XDrawImageString(dpy, win, gc, (outxy._curx * fwidth) + 2, (outxy._cury+1) * fheight, str, len > 0 ? len : 0);
}

int putch(char chr)
{
	static char str[]="\0\0";

	if(!(chr) || ((chr & 0xff) == LF)){
		clreol();
		outxy._curx = 0;
		outxy._cury += 1;
	} else {
		str[0] = chr;
		drawstring(str, 1);
		outxy._curx += 1;
	}

	return 0;
}

void cputs(char *prntstr)
{
	int strl = strlen(prntstr);

	drawstring(prntstr, strl);
	outxy._curx += strl;
}

// Erase from cursor to end of line.

void clreol()
{
	int tmpx = outxy._curx;
	int eollen = abs(screen_width+1 - tmpx);
	outxy._curx = outxy._curx <= screen_width ? outxy._curx : screen_width;
#ifdef THREED
	drawstring(eolbuf, eollen+1);
#else
	drawstring(eolbuf, eollen);
#endif /* THREED */
	outxy._curx = tmpx;
}

void normalvideo()
{
	XSetFont(dpy,gc,font->fid);
}

void boldvideo()
{
	XSetFont(dpy,gc,bfont->fid);
}

void highvideo()
{
	XSetBackground(dpy,gc,HiBgXColor.pixel);
	XSetForeground(dpy,gc,HiFgXColor.pixel);
	HiLo = -1;
}

void lowvideo()
{
	XSetBackground(dpy,gc,BgXColor.pixel);
	XSetForeground(dpy,gc,FgXColor.pixel);
	HiLo = 0;
}

void clrscr()
{
	XClearWindow(dpy,win);
}

void bell()
{
	XBell(dpy,100);
}

void update()
{
	flag[SHW] = 1;
	scr_update();
}

int scroll_text(int ycur)
{
	int d, rv = -1;

	flag[SHW] = 1;

	if(total_linec == scroll_height) {
		d = (ycur - yref)/(ftheight*2);
	} else {
		d = (ycur - yref)/ftheight;
	}


	// if cursor on or above top diamond
	if(ycur < ftheight) { rv = KEY_UP; goto stex;}

	// if cursor on or below bottom diamond
	else if(ycur > (vtot - ftheight)) { rv = KEY_DOWN; goto stex;}

	// move towards top
	else if(d < 0) {
		if(ycur < thumb_top/ftheight) rv = KEY_PPAGE;
		else rv = KEY_UP;
	}
	// move towards bottom
	else if(d > 0) {
		if(d > (vcur/ftheight)) rv = KEY_NPAGE;
		else rv = KEY_DOWN;
	}
stex:
	return(rv);
}

#ifndef XBR
struct frame {
        struct frame *next;
        
        WINDOW *win;            /* window or NULL */
        char   *name;           /* name displayed in statusbar */
        int     num;            /* window id or -1 if it cannot get focus */
        int     hidden;         /* if it is hidden */

        void  (*show) (void);
        void  (*draw) (void);
        void  (*set_focus) (void);
        void  (*unset_focus) (void);
};

extern struct frame *focused_window;

void draw_focus()
{
	// draw focused_window
	if(focused_window) {
		XSetForeground(dpy,gc,FgXColor.pixel);
		XDrawRectangle(dpy, win, gc, 
		(focused_window->win->begin_x*fwidth)+1,
		focused_window->win->begin_y > 5 ? (focused_window->win->begin_y-2)*(ftheight-2)-1 : (focused_window->win->begin_y-1)*(ftheight-2)+1, 
		focused_window->win->ncols*fwidth, 
		focused_window->win->begin_y > 5 ? ((focused_window->win->nlines+1)*(ftheight-2))-1 : ((focused_window->win->nlines+0)*(ftheight-2))-2
		);
	}
}
#endif

void show_vbar()
{
	ytru = display_start;
	ytot = total_linec;

//	draw_focus();

	// cant scroll 0 height window
	if(!scroll_height || !total_linec) return;

	// display window height in pixels
	vtot = (screen_height-1)*ftheight;

	// current line number to vertical thumb pos
	if(total_linec == scroll_height) {
		// min thumb size is 1/10 vtot, max is 2/3 vtot
		vcur = (vtot/scroll_height > vtot/10 ? vtot/scroll_height : vtot/10);
		vcur = (vcur > 2*vtot/3 ? 2*vtot/3 : vcur);
		pos = display_pos*vtot/scroll_height ? display_pos*vtot/scroll_height : 1;
	} else {
		vcur = (vtot*scroll_height/total_linec ? vtot*scroll_height/total_linec : vtot/10);
		vcur = (vcur > 2*vtot/3 ? 2*vtot/3 : vcur);
		pos = (((ytru*(vtot-(vcur-fheight)))/ytot) ? ((ytru*(vtot-(vcur-fheight)))/ytot) : 1);
	}
	thumb_top = (vtot-(6*(ftheight-2))-vcur > ftheight+pos-2) ? ftheight+pos-2 : vtot-(6*(ftheight-2))-vcur;
	yref = thumb_top + (vcur/2); // set for scroll_text

	// draw scrollbar trough
	XSetForeground(dpy,gc,HiBgXColor.pixel);
	XFillRectangle(dpy, win, gc, Width-11, 0, 11, Height);

	// draw thumb
	XSetForeground(dpy,gc,FgXColor.pixel);
	XDrawRectangle(dpy, win, gc, Width-10, thumb_top, 9, vcur);

	{
		XPoint opoints[] ={
							// draw left vert
							{Width-11,Height},
							{0,-Height},
							// down 1 char - 1 pixel
							{0,ftheight-1},
							// base of top triangle
							{11,0},
							// up center, down left, down to bottom tri
							{-5,-10},{-5,10},{0,Height+2-(2*(ftheight))},
							// doun center, up left, draw top of bottom tri
							{5,10},{5,-10},{-11,0},
							// to far left, down 1 char - 1 pixel
//							{-(Width-11),0},{0,-(ftheight-1)},
							// back to vbar
//							{Width-11,0}
						  };
#ifdef THREED
		XSegment lpoints[] ={{Width-1, thumb_top, Width-10, thumb_top},
							 {Width-10, thumb_top, Width-10, thumb_top+vcur-1},
							 {Width-10, ftheight-2, Width-5, ftheight-11},
							 {Width-9, Height+2-ftheight, Width-6, Height+3-ftheight+6}
							};

		// outline trough and end triangles with count of pairs in XPoint array
		XDrawLines(dpy, win, gc, opoints, 10, CoordModePrevious);

		// draw in light color for 3D shading
		XSetForeground(dpy,gc,BgXColor.pixel);

		XDrawSegments(dpy, win, gc, lpoints, 4);
#else
		// outline trough and end triangles with count of pairs in XPoint array
		XDrawLines(dpy, win, gc, opoints, 10, CoordModePrevious);

#endif //THREED
	}
	lowvideo();
}

void child_sig_handler(int signal)
{
	if (signal == SIGCHLD) wait(NULL);
}

void send_key(int c)
{
	if ((paste_text = 
		(char *) mrealloc(paste_text, paste_cnt + 1)) == NULL)
	{
		printf("paste realloc.\n");
		return;
	}
	paste_text[paste_cnt++] = (char)c;
}

void sig_handler(int nothing)
{
	update();
	XFlush(dpy);
}

int paste_primary(int win, int property, int Delete)
{
	Atom actual_type;
	int actual_format;
	long nitem, bytes_after;
	unsigned char *data;

	/* don't paste nothing or get data in the middle of previous paste */
	if ((property == None) || (paste_cnt != 0)) return(0);

	paste_text = NULL;
	paste_i = 0;

	/* get X-selection loop */
	do {
		if (XGetWindowProperty		/* get remaining selection max 1024 chars */
			(dpy, win, property, paste_cnt / 4, 1024, Delete,
			 AnyPropertyType, &actual_type, &actual_format, &nitem,
			 &bytes_after, (unsigned char **) &data)
			!= Success)
			return(0);
		/* stash the paste data */
		if ((paste_text = 
			(char *) mrealloc(paste_text, paste_cnt + nitem)) == NULL)
		{
			printf("paste realloc.\n");
			return(0);
		}
		memcpy(paste_text + paste_cnt, &data[0], nitem);
		paste_cnt += nitem;

		XFree(data);
	} while (bytes_after > 0);

	return(paste_cnt);
}

int request_selection(int time)
{
	Window w;
	Atom property;

	if ((w = XGetSelectionOwner(dpy, XA_PRIMARY)) == None) {
		int tmp = paste_primary(DefaultRootWindow(dpy), XA_CUT_BUFFER0, False);
		return(tmp);
	}
	property = XInternAtom(dpy, "VT_SELECTION", False);
	XConvertSelection(dpy, XA_PRIMARY, XA_STRING, property, win, time);
	return(0);
}

char *mrealloc(char *s, int len)
{
	char *ttt;
	if(!s) ttt = (char *) malloc(len);
	else ttt = (char *) realloc(s, len);
	return ttt;
}

void set_selection()
{
	int i, ty;
	char tbuf[MAXWLINE * MAXVLINE];
	char *tpo = tbuf;
	char *tpi;
	memset(tbuf,0, sizeof(tbuf));

	if(!flag[BLK] || mk == cur_pos) return;

	if(cur_pos < mk)
		{ bstart = cur_pos; bend = mk; }
	else
		{ bstart = mk; bend = cur_pos; }

	ty = ((bstart - &dispbuf[0]) / MAXWLINE);
	tpi = (char*)(&dispbuf[ty * MAXWLINE]);
	i = bstart - tpi;

	while(((char*)(&tpi[i]) < bend) && (ty < screen_height)) {
		*tpo++ = tpi[i++];
		if((tpi[-1] == '\n') || (i == screen_width)) {
			tpi += MAXWLINE;
			i = 0;
			ty++;
		}
	}

	selection_length = tpo - tbuf;
	if ((selection_text = (char *) mrealloc(selection_text, selection_length+1)) == NULL) {
		printf("realloc.\n");
se_exit:
		return;
	}
	for (i = 0; i < selection_length; i++) {
		selection_text[i] = tbuf[i] == EOL ? '\n' : tbuf[i];
	}

	XSetSelectionOwner(dpy, XA_PRIMARY, win, (Time) eve_time);
	if (XGetSelectionOwner(dpy, XA_PRIMARY) != win) {
		printf("Cant select.\n");
		goto se_exit;
	}
	XChangeProperty(dpy, DefaultRootWindow(dpy), XA_CUT_BUFFER0,
		XA_STRING, 8, PropModeReplace, selection_text,
		selection_length);
}

void send_selection(XSelectionRequestEvent * rq)
{
	XSelectionEvent notify;

	notify.type = SelectionNotify;
	notify.display = rq->display;
	notify.requestor = rq->requestor;
	notify.selection = rq->selection;
	notify.target = rq->target;
	notify.time = rq->time;
	XChangeProperty(dpy, rq->requestor, rq->property, XA_STRING, 8,
		PropModeReplace, selection_text, selection_length);
	notify.property = rq->property;
	XSendEvent(dpy, rq->requestor, False, 0, (XEvent *) & notify);
}

#ifndef MINIMAL
void parse_rc(FILE *f)
{
	char buf[512], *ptr;
	int i, l;
	while ((ptr=fgets(buf, 510, f))) {
		if (*ptr == '#' || isspace(*ptr)) continue;
		i = (int)*(ptr++) - (int)'a';
		if (*ptr==':' && i>=0 && i<26) {
			++ptr;
			while(isspace(*ptr)) ++ptr;
			l = strlen(ptr)-1;
			if (l>=0 && ptr[l]=='\n') ptr[l] = '\0';
			if (binding[i]) free(binding[i]);
			binding[i] = strdup(ptr);
		}
	}
}

void read_rc()
{
	FILE *fr = NULL;
	char name[NLEN], *ptr;

	if ((ptr=getenv("HOME")) || RcFile) {
		if (RcFile) {
			if (ptr && *RcFile == '~' && RcFile[1] == '/')
			sprintf(name, "%s/%s", ptr, RcFile+2);
			else
			strcpy(name, RcFile);
		}
		else
			sprintf(name, "%s/.%s", ptr, DEFAULT_RC);
	} else {
		sprintf(name, "%s/%s", SHARE_DIR, DEFAULT_RC);
	}
	fr = fopen(name, "r");
	if (fr) {
		parse_rc(fr);
		fclose(fr);
	}
}
#endif /* MINIMAL */

#ifdef DOGTK
static gboolean quit_gtk(GtkWidget *widget, GtkWidget *bw)
{
	gtk_main_quit();
	return 0;
}
#endif //DOGTK

void set_title(char *str)
{
	char b[NLEN];

	sprintf(b, EDIT" : %s", str);
	XStoreName(dpy, win, b);
}

void init(int argc,char *argv[])
{
	XWMHints *wmh;
	XSizeHints *xsh;
	XClassHint *classh;
	XColor tmp;
	int i, x = 1, y = 0, cnt = 0;

	/* Default settings */
	memset((void *)binding, 0, 26*sizeof(char *));
	*ewin.name = '\0';
	bstart = bend = dispbuf;
 
	/* engine screen width, height, font */
	screen_height = DEFAULT_HEIGHT;
	screen_width = DEFAULT_WIDTH;

	/* get command line options */
	for (i=1; i<argc; i++) {
		if (i<argc-1 && !strcasecmp(argv[i], "-fn"))
			FontName = argv[++i];
#ifndef MINIMAL
		else if (i<argc-1 && !strcasecmp(argv[i], "-rc"))
			RcFile = argv[++i];
#endif
		else if (i<argc-1 && !strcasecmp(argv[i], "-t"))
			{tabsize = atoi(argv[++i]); cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-fg"))
			{FgColor = argv[++i]; cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-bg"))
			{BgColor = argv[++i]; cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-xg"))
			{x = atoi(argv[++i]); cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-yg"))
			{y = atoi(argv[++i]); cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-b"))
			{do_background = 0; cnt += 1;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-hifg"))
			{HiFgColor = argv[++i]; cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-hibg"))
			{HiBgColor = argv[++i]; cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-cur"))
			{CrColor = argv[++i]; cnt += 2;}
		else if (i<argc-1 && !strcasecmp(argv[i], "-j"))
			{ewin.jump = atoi(argv[++i]); cnt += 2;}
#ifdef DOGTK
		else if (i<argc-1 && !strcasecmp(argv[i], "-x"))
			{xid = atoi(argv[++i]); cnt += 2;}
#endif //DOGTK
		else if (i<argc-1 && !strcasecmp(argv[i], "-w")) {
			screen_width = atoi(argv[++i]); cnt += 2;
			if (screen_width<20) screen_width = 20;
		} else if (i<argc-1 && !strcasecmp(argv[i], "-ht")) {
			screen_height = atoi(argv[++i]); cnt += 2;
			if (screen_height<5) screen_height = 5;
		} else if (!(*ewin.name))
		{
			char* p = strchr(argv[i], ':');
			if(p) {
				*p++ = '\0';
				ewin.jump = atoi(p);
			}
			if(argv[i]) strcat(ewin.name, argv[i]);
		}
	}

	if(ewin.name[0] != '\0') { argv[cnt] = argv[0];}
	gargc = argc - cnt;
	gargv = &argv[cnt];

#ifndef DOGTK
	/* open the display */
	dpy=XOpenDisplay(DisplayName);
#else //DOGTK
	if (!xid) {
	main_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* open the display */
	dpy=XOpenDisplay(DisplayName);
	}	
	else {
	main_win = gtk_plug_new(xid);
	gtk_window_set_title (GTK_WINDOW (main_win), "gdx");
	gtk_container_border_width (GTK_CONTAINER (main_win), 5);
	gtk_signal_connect(GTK_OBJECT(main_win), "destroy",
	 		GTK_SIGNAL_FUNC(quit_gtk), NULL);
	gtk_widget_realize(main_win);
	win = GDK_WINDOW_XWINDOW(main_win->window);
	dpy = GDK_WINDOW_XDISPLAY(main_win->window);
	}
#endif //DOGTK

	if(dpy==NULL)  {
		fprintf(stderr,"Can't open display: %s\n",DisplayName);
		sys_exit(1);
	}

	screen=DefaultScreen(dpy);

	/* establish window manager hints data structure */
	xsh=XAllocSizeHints();
	wmh=XAllocWMHints();
	classh=XAllocClassHint();

	/* setup font(s) */
	// normal font

	if(FontName == NULL) { FontName = FONTNAME; }

	font=XLoadQueryFont(dpy, FontName);
	if(font==NULL) {
		fprintf(stderr, "%s Font not found.\n", FontName);
		sys_exit(1);
	}

	fheight = font->ascent + font->descent;
	Height = fheight * screen_height + font->descent+3;

	// font true height as a constant
	ftheight = fheight+font->descent+1;

	/* font width */
	fwidth = XTextWidth(font,"8",1);

	Width = (fwidth * screen_width)+13;
	xsh->flags = PSize;
	xsh->width = Width;
	xsh->height = Height;

	// Bold font

	if(BFontName == NULL) { BFontName = BFONTNAME; }

	bfont=XLoadQueryFont(dpy, BFontName);
	if(bfont==NULL) {
		fprintf(stderr, "%s Bold Font not found.\n", BFontName);
		sys_exit(1);
	}

	bfheight = bfont->ascent + bfont->descent;
	BHeight = bfheight * screen_height + bfont->descent+3;

	/* font width */
	bfwidth = XTextWidth(bfont,"8",1);

	/* initialize clreol string to all blanks */
	memset(eolbuf, ' ', sizeof(eolbuf));

	/* create the only window */
#ifndef DOGTK
	win=XCreateSimpleWindow(dpy,RootWindow(dpy,screen),x,y,Width,Height,0,
		BlackPixel(dpy,screen),WhitePixel(dpy,screen));
#else //DOGTK
	if(!xid)
	  win=XCreateSimpleWindow(dpy,RootWindow(dpy,screen),x,y,Width,Height,0,
		BlackPixel(dpy,screen),WhitePixel(dpy,screen));
	else {
	gtk_widget_set_usize (GTK_WIDGET (main_win),Width,Height);
	gtk_widget_show(main_win);
	}
#endif //DOGTK

	/* setup window hints */
	wmh->initial_state=NormalState;
	wmh->input=True;
	wmh->window_group = win;
	wmh->flags = StateHint | InputHint | WindowGroupHint;

	/* setup window class resource names */
	classh->res_name = (AppName==NULL)?"OXElmo":AppName;
	classh->res_class = "Xedit";

	/* name that window */
	XmbSetWMProperties(dpy, win, "OXElmo", "oxelmo", argv, argc,
					xsh, wmh, classh);

	/* setup to gracefully respond to exit requests from X */
	DeleteWindow = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	XSetWMProtocols(dpy, win, &DeleteWindow, 1);

	/* specify accepted XEvent loop events */
	XSelectInput(dpy, win,
			KeyPressMask|\
			FocusChangeMask|\
			StructureNotifyMask|\
			ButtonPressMask|\
			ButtonReleaseMask|\
			ExposureMask|\
			PropertyChangeMask|\
			Button1MotionMask|\
			Button2MotionMask|\
			Button3MotionMask|\
			VisibilityChangeMask
	);
	keve = (XKeyEvent *)&xevent;

	/* create the Graphic Context for drawing purposes */
	gc=XCreateGC(dpy,win,0,NULL);

	/* allocate required colors */
	XAllocNamedColor(dpy,DefaultColormap(dpy,screen),FgColor,&FgXColor,&tmp);
	XAllocNamedColor(dpy,DefaultColormap(dpy,screen),BgColor,&BgXColor,&tmp);
	XAllocNamedColor(dpy,DefaultColormap(dpy,screen),CrColor,&CrXColor,&tmp);
	XAllocNamedColor(dpy,DefaultColormap(dpy,screen),HiFgColor,&HiFgXColor,&tmp);
	XAllocNamedColor(dpy,DefaultColormap(dpy,screen),HiBgColor,&HiBgXColor,&tmp);

	pixel_black = BlackPixel(dpy, screen);
	pixel_white = WhitePixel(dpy, screen);
	pixel_fg = pixel_black;
	pixel_bg = pixel_white;
	for (i = 0; i < 2*COLOR_PAIRS; i++) colors[i] = HiBgXColor.pixel;
	set_fgbg(pixel_fg, pixel_bg);

	/* apply colors to window */
	XSetForeground(dpy,gc,FgXColor.pixel);

#ifdef THREED
	XSetWindowBackground(dpy,win,BgXColor.pixel);
#endif

	/* set the font */
	XSetFont(dpy,gc,font->fid);

	/* map the window real */
	XMapWindow(dpy, win);

	/* set title with filename */
	set_title(ewin.name);

	/* app initialization */
//	br_startup(argc,argv);
}

/*
int handle_xkey(char *astr, int skey, int state)
{
#ifdef DEBUG
	char chstr[NLEN];
	int x=outxy._curx, y=outxy._cury, n=0;
	int x=cursorp_x, y=cursorp_x, n=0;

	// display keyboard shift/control/alt status
	highvideo();
	gotoxy(0,yy1);
	for(n=5;n;chstr[n--]=' ');
	if(state & ShiftMask) chstr[n++] = 'S';
	if(state & Mod1Mask) chstr[n++] = 'A';
	if(skey & 0xff00) chstr[n++] = 'F';
	if(state & ControlMask) chstr[n++] = '^';
	chstr[n] = skey & 0xff;
	chstr[5] = '\0';
	cputs(chstr);
	chstr[0] = '\0';

	// display raw key xevent data
	sprintf(chstr,"k=%4x,s=%2x.",skey,state);
	gotoxy(screen_width - 12,0);
	clreol();
	cputs(chstr);
	gotoxy(x,y);
#endif // DEBUG

	show_vbar();

	if(((skey >= 0xffe1) && (skey <= 0xffee)) || (skey == NoSymbol)) return 0;

	switch(executive) {
	case MAIN:
		exec_main(skey);
		break;
	case DIALOG:
		dialog(skey);
		break;
	case OPTIONS:
		options(skey);
		break;
	}
	return 0;
}
*/

/*
void do_select(int delete)
{
	if(flag[BLK] && mk != cur_pos) {
		set_selection();
	}
	mark_off();
}
*/

void do_paste()
{
	request_selection(xevent.xbutton.time);
}

Atom WM_PROTOCOLS = 0;

int main(int argc,char *argv[])
{
	struct sigaction sig;
	struct sigaction act;

#ifdef DOGTK
	gtk_init(argc,argv);
#endif //DOGTK

	init(argc,argv);
#ifndef MINIMAL
	read_rc();
#endif /* MINIMAL */

	/* disconnect from the console */
#ifdef DOGTK
	if(!xid && do_background)
#else
	if(do_background)
#endif //DOGTK
	// for that detached feeling
//	{switch (fork()) { case 0: case -1: break; default: exit(0); }}

	/* set path */
	if (cfdpath == NULL) {
		cfdpath = (char *) malloc(BUFSIZ);
		getcwd(cfdpath, BUFSIZ);
		if (strcmp(cfdpath, "/") != 0)
			strcat(cfdpath, "/");
	}

	usleep(10000);
	XFlush(dpy);

/* end of edit engine init */

	/* request/create WM_PROTOCOLS atom */
	WM_PROTOCOLS = XInternAtom(dpy, "WM_PROTOCOLS", False);

	// kill off zombie child processes
	act.sa_handler = child_sig_handler;
	act.sa_flags = 0;
	sigaction(SIGCHLD, &act, NULL);

	/* set up the signal handler response */
	sig.sa_handler=sig_handler;
	sigemptyset(&sig.sa_mask);
	sig.sa_flags=SA_RESTART;
	sigaction(SIGALRM,&sig,NULL);

	top();
	clear();
	exec_main(gargc,gargv);
	return(0);
}

#define DBLCLICK 500

int getCh(int block)
{
	int i;
	/* main event interpreter, dispatch function calls in response to events */
	for(;;)
	{
		static Time button_release_time;
		static int buttonpressed = 0;

		refresh();

		// take care of paste business
		if(paste_text != NULL)
		{
			int c = paste_text[paste_i++];
			if(paste_i == paste_cnt) {
				free(paste_text);
				paste_text = NULL;
				paste_cnt = 0;
				paste_i = 0;
			}
			return(c);
		}

		if (QLength(dpy) > 0) {
			XNextEvent(dpy,&xevent);
		}
		else {
			int fd;
			fd_set readfds;
			struct timeval tv;

			XFlush(dpy);
			/* Wait .1 second to see if a message arrives. */
			fd = ConnectionNumber(dpy);
			FD_ZERO(&readfds);
			FD_SET(fd, &readfds);
			tv.tv_sec = 0;
			tv.tv_usec = 100000;
			if (select(fd + 1, &readfds, 0, 0, &tv) == 1) {
				XNextEvent(dpy,&xevent);
			} else {
				return -1;
			}
		}

		switch(xevent.type)	{
		case Expose:
			// discard any backed up Expose events
			{ i = 128; while(XCheckTypedEvent(dpy,Expose,&xevent) && i--);}
			update();
			break;
		case MotionNotify:
			{ i = 128; while(XCheckTypedEvent(dpy,MotionNotify,&xevent) && i--);}
			if (buttonpressed==-1) {
				if (executive == MAIN) return(scroll_text(xevent.xbutton.y));
				break;
			}
			if(buttonpressed) {
				if(!flag[BLK]) block_mark();
				undraw_cursor();
				// if mouse cursor above top of window
				if (xevent.xbutton.y < 2) {
					return(KEY_UP);
				// if mouse cursor on last line or below of window
				} else if (xevent.xbutton.y >= Height-6-font->descent) {
					return(KEY_DOWN);
				// mouse cursor within window
				} else {
				if(flag[BLK]) { flag[SHW] = 1; }
					cur_pos = get_cur();
					gotoxy(x-1,y+1);
					draw_cursor();
				}
			}
			break;
		case ButtonPress:
			if((xevent.xbutton.button == Button5) || 
				(xevent.xbutton.button == Button4))
				break; /* ignore mouse wheel */
			// if mouse cursor in vertical scrollbar
			if (xevent.xbutton.x>=Width-10) {
				buttonpressed = -1;
				yref = xevent.xbutton.y;
				if (executive == MAIN) {show_vbar(); return(scroll_text(xevent.xbutton.y));}
				break;
			}
			buttonpressed = xevent.xbutton.button;
			if (xevent.xbutton.time - eve_time < DBLCLICK) break;
			eve_time = xevent.xbutton.time;
			if(xevent.xbutton.button == Button1) mark_off(); // unmark
			if(!mk){
				cur_pos = get_cur();
				block_mark();	// start new mark
			}
			break;
		case ButtonRelease:
			if (buttonpressed==-1) {
				buttonpressed = 0;
				break;
			}
			buttonpressed = 0;
			switch (xevent.xbutton.button) {
#ifdef TWOBUTN
				case Button5:
					if (executive == MAIN) return(0x0a);
					goto setcursor;
				case Button4:
					if (executive == MAIN) return(0x0b);
					goto setcursor;
				case Button1:
					// Double-click
					if (xevent.xbutton.time - button_release_time < DBLCLICK) {
						mark_off();
						return('\r');
					}
					else // click&drag
					{
						// leave click&drag left button highlighted
						button_release_time = xevent.xbutton.time;
						if(mk == cur_pos) mark_off();
						goto setcursor;
					}
					break;
				case Button3:
					// paste to cur_pos on right button click&release
					if ((xevent.xbutton.time - eve_time < DBLCLICK) &&
						(xevent.xbutton.time - eve_time)) {
						cur_pos = get_cur();
						mark_off(); 	// unmark
						do_paste();
						break;
					}
					else
					{
						// highlighted click&drag copyied to XA_PRIMARY
						// and then unhighlighted
						button_release_time = xevent.xbutton.time;
						set_selection();
						mark_off(); 	// unmark
					}
					goto setcursor;
#else
				case Button1:
				case Button3:
					if (xevent.xbutton.time - button_release_time < DBLCLICK) {
//						mark_off(); cursor_right(); word_left(); block_mark();	// set mark to left end of word
//						word_right(); // set mark to right end of word
						break;
					}
					else
					{
						button_release_time = xevent.xbutton.time;
						set_selection();
						goto setcursor;
					}
					break;
#endif // TWOBUTN
				case Button2:
					if ((xevent.xbutton.time - eve_time < DBLCLICK) &&
						(xevent.xbutton.time - eve_time)) {
//						do_paste();
					}
					goto setcursor;
			}
			break;
setcursor:
			flag[SHW] = 1;
			cur_pos = get_cur();
			scr_update();
			break;
		case KeyPress:{
				int count;
				KeySym skey;
				char astr[10] = "";
				{ i = 128; while(XCheckTypedEvent(dpy,KeyPress,&xevent) && i--);}
				eve_time = keve->time;
				astr[0] = 0;
				// convert key event to X-ascii in skey
				count = XLookupString(keve, astr,
						  sizeof (astr), &skey, NULL);
				// convert X-ascii and key state to control chars
				if((keve->state & ControlMask) && 
					(skey >= ' ') && 
					(skey <= 127))
						skey &= 0x1f;
				// ignore shift, control, Windows key presses
				if(skey == 0xffff) skey = 0x07;			// ^G for Del key
				if((skey & 0xfff0) == 0xffe0 && (skey != KEY_META))  {
					continue;	// ignore Ctrl/Sh
				}
				// convert X-ascii to standard ASCII
				if(skey == 0xff0d) skey = '\r';			// <Enter<
				if(skey == 0xff09) skey = '\t';			// <Tab>
				if(skey == 0xff1b) skey = 27;			// <Esc>
				// do paste on ^Ins
//				printf("skey=%x.\n", skey);
				if((skey == 0xff63) && (keve->state & ShiftMask)) do_paste();
				else return(skey);
			}
			break;
		case SelectionClear:
			break;
		case SelectionRequest:
			send_selection((XSelectionRequestEvent *) &xevent);
			break;
		case SelectionNotify:
			paste_primary(xevent.xselection.requestor,
				  xevent.xselection.property, True);
			break;
		case ConfigureNotify:
			{ i = 128; while(XCheckTypedEvent(dpy,ConfigureNotify,&xevent) && i--);}
			Width = xevent.xconfigure.width;
			screen_width = (Width-16)/fwidth;
			Height = xevent.xconfigure.height;
			screen_height = (Height/fheight);
			update();
//			return(KEY_RESIZE);
			break;
		case ClientMessage:
			if(xevent.xclient.message_type == WM_PROTOCOLS)	{
				if(xevent.xclient.data.l[0] == DeleteWindow) {
					sys_exit(0);
				};
			};
			break;
		case DestroyNotify:
			XCloseDisplay(dpy);
			if(!done) exit(0);
		done = 1;
			exit(1);
		default:
		}
	}
	return(-1);
}
