#ifndef __SELECT_H__
#define __SELECT_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "ecurses.h"
#include "search.h"

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

/**
 * win      -- selection window
 * bar      -- bar window
 * top_pos  -- index of item which is at the top of window
 * bar_pos  -- selected item index
 */
typedef struct select {
        WINDOW     *win;
        WINDOW     *bar;
        int         top_pos;
        int         bar_pos;

        int       (*count) (struct select *select);
        void      (*draw_line) (WINDOW *win, int maxlen, int index,
                                search_t *search);
        int       (*match)(search_t *search, int index);
} select_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void   select_init (void);
extern chtype select_bar_color (void);
extern chtype select_hilight_color (void);

extern select_t *select_open (WINDOW *win, int no_bar,
                              void (*draw_line) (WINDOW *, int, int,
                                                 search_t *),
                              int (*count) (select_t *));

extern void select_close (select_t *select);
extern void select_show (select_t *select);
extern void select_next (select_t *select);
extern void select_prev (select_t *select);
extern void select_scroll_down (select_t *select);
extern void select_scroll_up (select_t *select);
extern void select_next_page (select_t *select);
extern void select_prev_page (select_t *select);
extern void select_first (select_t *select);
extern void select_last (select_t *select);
extern void select_recenter (select_t *select);
extern void select_goto (select_t *select, int index);
extern void select_redraw (select_t *select);
extern void select_search_setup_forward (select_t *select,
                                         int (*match)(search_t *, int));
extern void select_search_setup_backward (select_t *select,
                                          int (*match)(search_t *, int));

/** repeat forward search */
extern void select_search_forward (void);
/** repeat backward search */
extern void select_search_backward (void);
/** delete last character from search string */
extern void select_search_backspace (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER select.h
 *
 ****************************************************************************/
#endif
