#ifndef __POP_H__
#define __POP_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdio.h>

#include "mail.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

enum auth_method {
        AUTH_PLAIN,
        AUTH_APOP,
};

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void pop_init (void);
extern void pop_free_resources (void);

extern int  pop_open (const char *hostname, unsigned short port,
                      const char *user, const char *pass, enum auth_method m,
                      int secure, void (*succ)(void), void (*fail)(void));
extern void pop_close (void (*succ)(void), void (*fail)(void));
extern int  pop_maildrop_size (void);
extern int  pop_maildrop_count (void);
extern void pop_list (void (*succ)(void), void (*fail)(void));
extern void pop_uidl (void (*succ)(void), void (*fail)(void));
extern void pop_get_infos (void (*succ)(void), void (*fail)(void));
extern void pop_retr (int num, FILE *fp, void (*succ)(void),
                      void (*fail)(void));
extern void pop_dele (int num, void (*succ)(void), void (*fail)(void));
extern void pop_rset (void (*succ)(void), void (*fail)(void));

extern void pop_save_list (void);
extern void pop_load_list (void);
extern void pop_merge_lists (void);

extern int     pop_mail_size (int num);
extern int     pop_header_count (void);
extern mail_t *pop_header_info (int index);
extern int     pop_num (int index);
extern void    pop_mark_mail (int index);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER pop.h
 *
 ****************************************************************************/
#endif
