#ifndef __MLEX_H__
#define __MLEX_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------
   
   This simple module acts as message parser.  It can parse a file in mbox
   format or just a single mail (in which situation you have to give it a
   date).


   1. Reading one mail

   It is very easy to parse just one mail.  Assign yyin valid file
   descriptor, call set_single_mail with mail date, and finally call
   mbox_scan.
   

   2. Reading many mails

   Assign yyin valid file descriptor and call mbox_scan.  First invocation
   is void.  You won't get any data.  It's just for test if this file is
   a mailbox in mbox format.


   3. Retrieving data

   After successful call to mbox_scan you can get mail data from newmail
   pointer.  It points to static buffer so you should copy this data
   somewhere before next call to mbox_scan.
   
*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdio.h>
#include <time.h>

#include "mail.h"

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

#define NEXT_MAIL     300
#define END_OF_FILE   301
#define BROKEN_MAIL   302
#define EOF_AT_HEADER 303

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

extern FILE   *yyin;
extern FILE   *yyout;
extern mail_t *newmail;

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void mlex_init (void);
extern void mlex_free_resources (void);

extern int mlex_scan (void);
extern int mlex_mbox_scan_start (void);
extern int mlex_scan_file (time_t tm);
extern int mlex_scan_buffer (char *buf);
extern int mlex_outmail_scan (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER mlex.h
 *
 ****************************************************************************/
#endif
