/* -*- c -*- */
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#define FOCUS     1
#define LABEL_TXT 1
#define LABEL_DEF 0


#ifndef GET_COLOR_DEFINED
#define GET_COLOR_DEFINED 1

static chtype
get_color (ask_t *ask, const char *fg_field, const char *bg_field,
           const char *fg_def, const char *bg_def)
{
        char *fg;
        char *bg;

        fg = ask_get_field (ask, fg_field);
        bg = ask_get_field (ask, bg_field);

        if (fg && bg){
                return color_from_str (fg, bg);
        }
        else if (fg){
                return color_from_str (fg, bg_def);
        }
        else if (bg){
                return color_from_str (fg_def, bg);
        }
        return color_from_str (fg_def, bg_def);
}

#endif


static WINDOW *
interface_init (void)
{
        ask_t  *ask       = ask_select_default ("win_mail");
        int     height    = -3;
        int     width     = 0;
        int     top       = 1;
        int     left      = 0;
        int     maxheight = LINES;
        int     maxwidth  = COLS;
        WINDOW *win;

        sigok_color = get_color (ask, "sigok_fg", "sigok_bg", "lime", "black");
        text_color = get_color (ask, "text_fg", "text_bg", "lightgrey", "black");
        signature_color = get_color (ask, "signature_fg", "signature_bg", "cyan", "black");
        date_color = get_color (ask, "date_fg", "date_bg", "cyan", "black");
        mua_color = get_color (ask, "mua_fg", "mua_bg", "cyan", "black");
        quote_color = get_color (ask, "quote_fg", "quote_bg", "green", "black");
        sigfail_color = get_color (ask, "sigfail_fg", "sigfail_bg", "red", "black");
        subject_color = get_color (ask, "subject_fg", "subject_bg", "cyan", "black");
        hilight_color = get_color (ask, "hilight_fg", "hilight_bg", "black", "green");
        sigwarn_color = get_color (ask, "sigwarn_fg", "sigwarn_bg", "yellow", "black");
        replyto_color = get_color (ask, "replyto_fg", "replyto_bg", "cyan", "black");
        from_color = get_color (ask, "from_fg", "from_bg", "cyan", "black");
        to_color = get_color (ask, "to_fg", "to_bg", "cyan", "black");
        cc_color = get_color (ask, "cc_fg", "cc_bg", "cyan", "black");

        top = ask_get_field_int_default (ask, "top", 1);
        width = ask_get_field_int_default (ask, "width", 0);
        height = ask_get_field_int_default (ask, "height", -3);
        left = ask_get_field_int_default (ask, "left", 0);


        if (height <= 0)
                height += maxheight;
        if (width <= 0)
                width += maxwidth;
        if (top < 0)
                top += maxheight;
        if (left < 0)
                left += maxwidth;

        if (height > maxheight)
                height = maxheight;
        if (width > maxwidth)
                width = maxwidth;

        if (top + height > maxheight)
                top = maxheight - height;
        if (left + width > maxwidth)
                left = maxwidth - width;

        win = window_create ("mail", height, width, top, left, 1);

        if (ask){
#if FOCUS
                if (ask_get_field_int_default (ask, "label", 0)){
                        label = label_create (win);
                }
                else {
                        label = NULL;
                }
#endif /* FOCUS */
                ask_destroy (ask);
        }
#if LABEL_DEF
        else {
                label = label_create (win);
        }
#endif /* LABEL_DEF */


#if LABEL_TXT
        if (label){
                label_set_text (label,  "message reader");
        }
#endif /* LABEL_TXT */

        wattrset (win, text_color);
        return win;
}
