/* -*- c -*- */
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#define FOCUS     0
#define LABEL_TXT 0
#define LABEL_DEF 0


#ifndef GET_COLOR_DEFINED
#define GET_COLOR_DEFINED 1

static chtype
get_color (ask_t *ask, const char *fg_field, const char *bg_field,
           const char *fg_def, const char *bg_def)
{
        char *fg;
        char *bg;

        fg = ask_get_field (ask, fg_field);
        bg = ask_get_field (ask, bg_field);

        if (fg && bg){
                return color_from_str (fg, bg);
        }
        else if (fg){
                return color_from_str (fg, bg_def);
        }
        else if (bg){
                return color_from_str (fg_def, bg);
        }
        return color_from_str (fg_def, bg_def);
}

#endif


static WINDOW *
interface_init (void)
{
        ask_t  *ask       = ask_select_default ("win_frames");
        int     height    = -3;
        int     width     = 0;
        int     top       = 1;
        int     left      = 0;
        int     maxheight = LINES;
        int     maxwidth  = COLS;
        WINDOW *win;

        frame_color = get_color (ask, "frame_fg", "frame_bg", "lightgrey", "black");
        text_color = get_color (ask, "text_fg", "text_bg", "lightgrey", "black");
        fill_color = get_color (ask, "fill_fg", "fill_bg", "lightgrey", "lightgrey");

        f_left = ask_get_field (ask, "f_left");
        if (f_left == NULL){
                f_left = "(25 -8 25 -8)";
        }
        f_horiz = ask_get_field (ask, "f_horiz");
        if (f_horiz == NULL){
                f_horiz = "(0 -8 24 -8)";
        }
        f_right = ask_get_field (ask, "f_right");
        if (f_right == NULL){
                f_right = "";
        }
        f_vert = ask_get_field (ask, "f_vert");
        if (f_vert == NULL){
                f_vert = "(25 1 25 -1)";
        }
        no_frames = ask_get_field_int_default (ask, "no_frames", 0);
        fill = ask_get_field (ask, "fill");
        if (fill == NULL){
                fill = "(25 0 25 0)";
        }
        f_cross = ask_get_field (ask, "f_cross");
        if (f_cross == NULL){
                f_cross = "";
        }
        f_down = ask_get_field (ask, "f_down");
        if (f_down == NULL){
                f_down = "";
        }
        f_up = ask_get_field (ask, "f_up");
        if (f_up == NULL){
                f_up = "";
        }


        if (height <= 0)
                height += maxheight;
        if (width <= 0)
                width += maxwidth;
        if (top < 0)
                top += maxheight;
        if (left < 0)
                left += maxwidth;

        if (height > maxheight)
                height = maxheight;
        if (width > maxwidth)
                width = maxwidth;

        if (top + height > maxheight)
                top = maxheight - height;
        if (left + width > maxwidth)
                left = maxwidth - width;

        win = window_create ("frames", height, width, top, left, 0);

        if (ask){
#if FOCUS
                if (ask_get_field_int_default (ask, "label", 0)){
                        label = label_create (win);
                }
                else {
                        label = NULL;
                }
#endif /* FOCUS */
                ask_destroy (ask);
        }
#if LABEL_DEF
        else {
                label = label_create (win);
        }
#endif /* LABEL_DEF */


#if LABEL_TXT
        if (label){
                label_set_text (label, no_label);
        }
#endif /* LABEL_TXT */

        wattrset (win, text_color);
        return win;
}
