/* -*- c -*- */
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#define FOCUS     1
#define LABEL_TXT 1
#define LABEL_DEF 1


#ifndef GET_COLOR_DEFINED
#define GET_COLOR_DEFINED 1

static chtype
get_color (ask_t *ask, const char *fg_field, const char *bg_field,
           const char *fg_def, const char *bg_def)
{
        char *fg;
        char *bg;

        fg = ask_get_field (ask, fg_field);
        bg = ask_get_field (ask, bg_field);

        if (fg && bg){
                return color_from_str (fg, bg);
        }
        else if (fg){
                return color_from_str (fg, bg_def);
        }
        else if (bg){
                return color_from_str (fg_def, bg);
        }
        return color_from_str (fg_def, bg_def);
}

#endif


static WINDOW *
interface_init (void)
{
        ask_t  *ask       = ask_select_default ("win_abook");
        int     height    = -4;
        int     width     = -26;
        int     top       = 2;
        int     left      = 26;
        int     maxheight = LINES;
        int     maxwidth  = COLS;
        WINDOW *win;

        text_color = get_color (ask, "text_fg", "text_bg", "lightgrey", "black");
        picked_color = get_color (ask, "picked_fg", "picked_bg", "lime", "black");
        hilight_color = get_color (ask, "hilight_fg", "hilight_bg", "black", "green");
        picked_bar_color = get_color (ask, "picked_bar_fg", "picked_bar_bg", "lime", "cyan");

        top = ask_get_field_int_default (ask, "top", 2);
        width = ask_get_field_int_default (ask, "width", -26);
        height = ask_get_field_int_default (ask, "height", -4);
        abook_fmt = ask_get_field (ask, "abook_fmt");
        if (abook_fmt == NULL){
                abook_fmt = "%s %020n %030e %g";
        }
        left = ask_get_field_int_default (ask, "left", 26);


        if (height <= 0)
                height += maxheight;
        if (width <= 0)
                width += maxwidth;
        if (top < 0)
                top += maxheight;
        if (left < 0)
                left += maxwidth;

        if (height > maxheight)
                height = maxheight;
        if (width > maxwidth)
                width = maxwidth;

        if (top + height > maxheight)
                top = maxheight - height;
        if (left + width > maxwidth)
                left = maxwidth - width;

        win = window_create ("abook", height, width, top, left, 1);

        if (ask){
#if FOCUS
                if (ask_get_field_int_default (ask, "label", 1)){
                        label = label_create (win);
                }
                else {
                        label = NULL;
                }
#endif /* FOCUS */
                ask_destroy (ask);
        }
#if LABEL_DEF
        else {
                label = label_create (win);
        }
#endif /* LABEL_DEF */


#if LABEL_TXT
        if (label){
                label_set_text (label,  "Addressbook");
        }
#endif /* LABEL_TXT */

        wattrset (win, text_color);
        return win;
}
