
/*
  A small vertical, xlib only, single parameter, general purpose pop-up menu.
  version 3.00, Copyright (C) 2005 Terry Loveall, <loveall@iinet.com>
  THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY OR BINARIES. COMPILE AND USE 
  AT YOUR OWN RISK.
*/

#include	"menu.h"

char version[] = "Menu 3.00\n";
Display * dpy;			/* The connection to the X server. */
int display_width;		/* The width of the screen we're managing. */
int display_height;		/* The height of the screen we're managing. */

Window window;			/* Main window. */
Window root;			/* Root window. */
GC gc;					/* The default GC. */

unsigned long black;	/* Black pixel. */
unsigned long white;	/* White pixel. */

XFontStruct * font;		/* Font. */
Cursor mouse_cursor;	/* Mouse cursor. */

MenuItem * menu = 0;
MenuItem * selected = 0;

FILE * shell;
char * param = NULL;
char * argv0;
int numlines = 0;
int cury = -1;
int max_chars = 0;
int WinHeight;
int WinWidth;
int not_done = -1;
int itemHeight;

static void readMenu(int argc, char *argv[]);
static MenuItem *whichItem(int mouseY);
static void addMenuItem(char *, char *);
static void getEvent(XEvent *);
static void initCursor(void);

static void execute(MenuItem *);
static void nullEvent(XEvent *);
static void buttonPress(XEvent *);
static void buttonRelease(XEvent *);
static void mouseMoved(XEvent *);
static void expose(XEvent *);
static void mappingnotify(XEvent *);

/* Dispatcher for main event loop. */
typedef struct Disp Disp;
struct Disp {
	int	type;
	void	(*handler)(XEvent *);
};

static Disp disps[] = {
	{NullEvent, nullEvent},
	{ButtonPress, buttonPress},
	{ButtonRelease, buttonRelease},
	{MotionNotify, mouseMoved},
	{Expose, expose},
	{EnterNotify, nullEvent},
	{LeaveNotify, nullEvent},
	{MappingNotify, mappingnotify},
	{VisibilityNotify, nullEvent},
};

/*ARGSUSED*/
int
main(int argc, char *argv[]) {
	XEvent ev;
	XGCValues gv;
	XSetWindowAttributes attr;
	int root_x, root_y, dudi;
	Window dud;
	
	argv0 = argv[0];
	
	/* Open a connection to the X server. */
	dpy = XOpenDisplay("");
	if (dpy == 0)
		Panic("can't open display.");
	
	/* Find the screen's dimensions. */
	display_width = DisplayWidth(dpy, DefaultScreen(dpy));
	display_height = DisplayHeight(dpy, DefaultScreen(dpy));
	
	/* Get the pixel values of the only two colours we use. */
	black = BlackPixel(dpy, DefaultScreen(dpy));
	white = WhitePixel(dpy, DefaultScreen(dpy));
	
	/* Get font. */
	font = XLoadQueryFont(dpy, "7x14");
	if (font == 0)
		Panic("can't find a font.");
	
	/* Get a cursor. */
	initCursor();
	
	shell=popen("/bin/sh","w");

	/* Create the menu items. */
	readMenu(argc, argv);
	
	/* Create the window. */
	root = DefaultRootWindow(dpy);
	attr.override_redirect = True;
	attr.background_pixel = white;
	attr.border_pixel = black;
	attr.cursor = mouse_cursor;
	attr.event_mask = ExposureMask | VisibilityChangeMask |
		ButtonMotionMask | PointerMotionMask |
		ButtonPressMask | ButtonReleaseMask | StructureNotifyMask |
		EnterWindowMask | LeaveWindowMask | KeyPressMask;
	WinHeight = numlines * (1.2 * (font->ascent + font->descent));
	WinWidth = max_chars + 20;

	XQueryPointer(dpy, root, &dud, &dud, &root_x, &root_y, &dudi, &dudi, &dudi);

	window = XCreateWindow(dpy, root,
		root_x - (WinWidth / 2) >= 0 ? root_x - (WinWidth / 2) : 0,
		(root_y - WinHeight - 5) >= 0 ? root_y - WinHeight - 5 : 0,
		WinWidth, WinHeight,
		1, CopyFromParent, InputOutput, CopyFromParent,
		CWOverrideRedirect | CWBackPixel | CWBorderPixel |
		CWCursor | CWEventMask,
		&attr);

	/* Create GC. */
	gv.foreground = black;
	gv.background = white;
	gv.font = font->fid;
	gc = XCreateGC(dpy, window, GCForeground | GCBackground | GCFont,
		&gv);
	
	// set itemHeight to font full height
	itemHeight = (1.2 * (font->ascent + font->descent));

	/* Bring up the window. */
	XMapRaised(dpy, window);
	
	XGrabKeyboard(dpy, window, True, GrabModeAsync, GrabModeAsync, CurrentTime);

	/* Make sure all our communication to the server got through. */
	XSync(dpy, False);
	
	/* The main event loop. */
	while (not_done) {
		getEvent(&ev);
		dispatch(&ev);
	}
	XUngrabKeyboard(dpy, CurrentTime);
	pclose(shell);
	exit(0);
}

static void keyItem(int inc)
{
	if((inc < 0) && (cury <= itemHeight)) cury = (numlines +1) * itemHeight;
	if((inc > 0) && (cury >= (numlines * itemHeight)-1)) cury = -1;
	cury += inc;
	selected = whichItem(cury);
	expose(0);
}

static void getEvent(XEvent * ev) {
	int fd;
	fd_set readfds;
	struct timeval tv;
	
	/* Is there a message waiting? */
	if (QLength(dpy) > 0) {
		XNextEvent(dpy, ev);
		return;
	}
	
	/* Beg... */
	XFlush(dpy);
	
	/* Wait 1 second to see if a message arrives. */
	fd = ConnectionNumber(dpy);
	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);
	tv.tv_sec = 1;
	tv.tv_usec = 0;
	if (select(fd + 1, &readfds, 0, 0, &tv) == 1) {
		XKeyEvent *keve = (XKeyEvent *)ev;
		XNextEvent(dpy, ev);
		if(keve->type == KeyRelease)
		{
			int count;
			KeySym skey;
			char astr[10] = "";
			// convert key event to X-ascii in skey
			count = XLookupString(keve, astr, sizeof (astr), &skey, NULL);
			if(skey == 0xff1b) not_done = 0;			// <Esc> just exits
			if(skey == 0xff52) keyItem(-itemHeight);	// Up - prev
			if(skey == 0xff54) keyItem(itemHeight);		// Down - next
			if(skey == 0xff0d) buttonRelease(NULL);		// <Enter> execute selected
		}
		return;
	}
	
	/* No message, so we have a null event. */
	ev->type = NullEvent;
}

static void
initCursor() {
	XColor red, white, exact;
	Colormap cmp = DefaultColormap(dpy, DefaultScreen(dpy));
	XAllocNamedColor(dpy, cmp, "red", &red, &exact);
	XAllocNamedColor(dpy, cmp, "white", &white, &exact);
	mouse_cursor = XCreateFontCursor(dpy, XC_left_ptr);
}

static void
addMenuItem(char * name, char * command) {
    int tmp = 0;
	MenuItem * newItem = (MenuItem *) malloc(sizeof(MenuItem));
	if (newItem == 0)
		return;
	
	newItem->next = 0;
	newItem->name = strdup(name);
	newItem->command = strdup(command);
	tmp = XTextWidth(font, newItem->name, strlen(newItem->name));
	
	if (menu == 0) {
		menu = newItem;
	} else {
		MenuItem * last = menu;
		while (last->next != 0)
			last = last->next;
		last->next = newItem;
	}
	numlines++; // count lines in menu
	if(tmp > max_chars) max_chars = tmp;
}

static void
readMenu(int argc, char *argv[]) {
	FILE * fp;
	char* f;
	char line[BUFSIZ];

	switch (argc)
	{
		case 1:
			f=".menu";		/* default menu file to open in current dir */
			break;
		case 2:
			f=argv[1];		/* named menu file to open */
			break;
		case 3:
			f=argv[1];		/* named  menu file to open */
			param = argv[2];	/* passed param always requires named menu file */
			break;
		default:
			fprintf(stderr,"usage: menu [menu-file] [parameter]\n");
			exit(1);
	}

	if (param) {  /* 'param' set to argv[2] */
		char sb[BUFSIZ];
		sprintf(sb,"F=%s\n",param);
		fputs(sb,shell);	/* pass argv[2] as string variable '$F' */
		fflush(shell);
	}

	fp = fopen(f, "r");
	if (fp == 0) {
		addMenuItem("localhost", "exec xterm");
		return;
	}
	
	while (fgets(line, BUFSIZ, fp) != 0) {
		char * tab = strchr(line, '\t');
		if (*line == '#' || tab == 0)
			continue;
		if(tab == line) {
			fputs(++tab,shell);	/* execute inline tab prefixed shell code */
			fflush(shell);
			continue;
		}
		*tab = 0;
		addMenuItem(line, tab+1);
	}
	
	fclose(fp);
}

static MenuItem *
whichItem(int mouseY)
{
	int y = 0;
	MenuItem * item;
	
	for (item = menu; item != 0; item = item->next) {
		if (mouseY >= y && mouseY <= (y + itemHeight)) {
			cury = mouseY;
			return item;
		}
		y += itemHeight;
	}
	
	return 0;
}

extern void
dispatch(XEvent * ev) {
	Disp * p;
	
	for (p = disps; p < disps + sizeof disps / sizeof disps[0]; p++) {
		if (p->type == ev->type) {
			if (p->handler != 0)
				p->handler(ev);
			return;
		}
	}
}

static void
expose(XEvent * ev) {
	int x, y;
	MenuItem * item;
	
	/* Only handle the last in a group of Expose events. */
	if (ev && ev->xexpose.count != 0)
		return;
	
	/* Clear the window. */
	XClearWindow(dpy, window);
	XSetForeground(dpy, gc, black);
	
	/* Draw the menu. */
	x = 10;
	y = 0 + ( 1.1 * (font->ascent));

	for (item = menu; item != 0; item = item->next) {
		if (item == selected) {
			XSetFunction(dpy, gc, GXinvert);
			XFillRectangle(dpy, window, gc, 0, y - (1.2 * (font->ascent + font->descent)) + 3, WinWidth, 19);
			XSetFunction(dpy, gc, GXcopy);
			XSetForeground(dpy, gc, white);
		} else {
			XSetForeground(dpy, gc, black);
		}
		XDrawString(dpy, window, gc, x, y,item->name, strlen(item->name));
		y += (1.2 * (font->ascent + font->descent));
	}
}

static void
nullEvent(XEvent * ev) {
	expose(0);
}

static void
mouseMoved(XEvent * ev) {
	while (XCheckTypedEvent(dpy, MotionNotify, ev)) ;
	
	selected = whichItem(ev->xmotion.y); expose(0);
}

static void
buttonPress(XEvent * ev) {
	selected = whichItem(ev->xbutton.y);
	expose(0);
}

static void
buttonRelease(XEvent * ev) {
	if (selected != 0) {
		execute(selected);
		selected = 0;
	}
	expose(0);
}

static void
mappingnotify(XEvent * ev) {
	XRefreshKeyboardMapping((XMappingEvent *) ev);
}

static void
execute(MenuItem * item)
{
	not_done = 0;	// exit after one execution

	if (item->command != 0) fputs(item->command,shell);
	fflush(shell);
}

void
Panic(char *s) {
	fprintf(stderr, "%s: %s\n", argv0, s);
	exit(EXIT_FAILURE);
}
