/***************************************************************************
 * Header for the tray functions.
 * Copyright (C) 2004 Joe Wingbermuehle
 ***************************************************************************/

#ifndef TRAY_H
#define TRAY_H

extern int trayHeight;
extern int trayWidth;
extern int trayX, trayY;

extern Window trayWindow;
extern int autoHideTray;
extern int trayIsHidden;

void CreateTray();
void DestroyTray();

void ShowTray();
void HideTray();

void FocusNext();

void NextDesktop();
void PreviousDesktop();
void ChangeDesktop(int desktop);

void DrawTray();
int UpdateTime();
void UpdatePager();

void AddClientToTray(ClientNode *np);
void RemoveClientFromTray(ClientNode *np);

int ProcessTrayEvent(const XEvent *event);

void SetTrayHeight(const char *str);
void SetTrayWidth(const char *str);
void SetTrayAlignment(const char *str);
void SetClockProgram(const char *command);
void SetLoadProgram(const char *command);
void SetMenuTitle(const char *title);
void SetMenuIcon(const char *name);

#endif

