/***************************************************************************
 * Functions to handle the root menu.
 * Copyright (C) 2004 Joe Wingbermuehle
   Modifications Copyright (C) 2005 Terry Loveall <loveall@iinet.com>
 ***************************************************************************/

#include "jwm.h"

static MenuType *rootMenu = NULL;
static int initialized = 0;
static void ExitHandler(ClientNode *np);

/***************************************************************************
 ***************************************************************************/
void SetRootMenu(MenuType *m) {
	if(rootMenu) {
		DestroyRootMenu();
	}
	rootMenu = m;
	initialized = 0;
}

/***************************************************************************
 ***************************************************************************/
void DestroyRootMenu() {
	DestroyMenu(rootMenu);
	rootMenu = NULL;
	initialized = 0;
}

/***************************************************************************
 ***************************************************************************/
void ShowRootMenu(int x, int y) {

	if(!rootMenu) {
		return;
	}

	if(!initialized) {
		initialized = 1;
		InitializeMenu(rootMenu);
	}

	ShowMenu(rootMenu, RunCommand, x, y);

}

/***************************************************************************
 ***************************************************************************/
void ExitHandler(ClientNode *np) {
	shouldExit = 1;
}

/***************************************************************************
 ***************************************************************************/
void RunCommand(const char *command) {
	char *displayString;
	char *str;

	if(!command) {
		return;
	}

	if(!strncmp(command, "#exit", 5)) {

		if(exitCommand) {
			Release(exitCommand);
			exitCommand = NULL;
		}
		if(strlen(command) > 6) {
			exitCommand = Allocate(strlen(command) - 5 + 1);
			strcpy(exitCommand, command + 6);
		}

#ifndef CLICK_TO_FOCUS
		ShowConfirmDialog(NULL, ExitHandler,
			"Exit JWM",
			"Are you sure?",
			NULL);
#else
		// yes I am sure I am sure.
		// Paranoid verification option not available but could be :-)
		ExitHandler(NULL);
#endif
		return;
	} else if(!strcmp(command, "#restart")) {
		shouldRestart = 1;
		shouldExit = 1;
		return;
	}

	displayString = DisplayString(display);

	if(!fork()) {
		if(!fork()) {
			close(ConnectionNumber(display));
			if(displayString && displayString[0]) {
				str = malloc(strlen(displayString) + 9);
				sprintf(str, "DISPLAY=%s", displayString);
				putenv(str);
			}
			execl(SHELL_NAME, SHELL_NAME, "-c", command, NULL);
			Warning("exec failed: (%s) %s", SHELL_NAME, command);
			exit(1);
		}
		exit(0);
	}

	wait(NULL);

}

