
// bcalc.h for duuumb xlib only curses clone. replaces #include <curses.h>

/* bcalc.h Copyright (C) March 3, 2004, Terry Loveall <loveall@qwest.net>
This program is released into the public domain.

THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY OR BINARIES. COMPILE AND USE 
AT YOUR OWN RISK.
*/

#define ERR     (-1)
#define OK      (0)
#define TRUE    (1)
#define FALSE   (0)
//#define EOF     (-1)
#define A_CHARTEXT     0xFF
#define A_NORMAL        0x0
#define A_REVERSE       0x1
#define A_UNDERLINE     0x2
#define A_BOLD          0x4
#define A_BLINK         0x7
#define COLS screen_width-1
#define LINES screen_height
#define BUTTON1_CLICKED 1
#define BUTTON2_CLICKED 2
#define BUTTON3_CLICKED 3

// curses replacement defs:

#define KEY_MOUSE  0x21b
#define KEY_RESIZE 0x222
#define KEY_BACKSPACE 0xff08
#define KEY_DEL 0x0007
#define KEY_END 0xff57
#define KEY_ENTER 0xff0d
#define KEY_HOME 0xff50
#define KEY_NPAGE 0xff56
#define KEY_PPAGE 0xff55
#define KEY_LEFT 0xff51
#define KEY_UP 0xff52
#define KEY_RIGHT 0xff53
#define KEY_DOWN 0xff54
#define KEY_HELP 0xffbe
#define KEY_CANCEL 0xFF69
#define KEY_TAB 0xFF09
#define KEY_IC 0xFF63
#define KEY_DC 0xFFFF

typedef unsigned long chtype;
typedef chtype attr_t;
typedef struct
{
        int _cury, _curx;		/* current cursor position */
        int nlines, ncols;		/* height, width */
        int begin_y, begin_x;	/* upper left y,x */
} WINDOW;

typedef struct
{
        int x;           /* absolute column, 0 based, measured in characters */
        int y;           /* absolute row, 0 based, measured in characters */
        int button;      /* Xlib button state */
        int changes;     /* holds prev _different_ button */
} MOUSE_STATUS;

// externs data defs here
extern int display_start;	// xbr vbar thumb position
extern int total_linec;		// xbr vbar total span
extern int scroll_height;	// xbr vbar scroll window height
extern int scroll_width;	// xbr vbar scroll window width

extern MOUSE_STATUS last_click;
extern WINDOW *stdscr;
#define  cursorp_x stdscr->_curx
#define  cursorp_y stdscr->_cury
extern int screen_width;
extern int screen_height;
extern int COLOR_PAIRS;
#define COLOR_PAIR(x) ((x) << 8)

// extern func proto here
//extern void handle_command_code(int);
//extern void window_redraw_all();
extern void set_title(char *str);
extern void exec_main(int argc,char *argv[]);
extern void cbreak(void);
extern void nonl(void);
extern void intrflush(void *, int);
extern void keypad(void *, int);
extern void nodelay(void *, int);
extern void echo(void);
extern void noecho(void);
extern void echo(void);
extern void raw(void);
extern void noraw(void);
extern void scrollok(void *, int);
extern void endwin(void);
extern void initscr(void);
extern void beep(void);

extern void move(int, int);

extern void attrset(int);
extern void attron(int);
extern void attroff(int);

extern int inch(void);
extern int mvinch(int y, int x);

extern void addch(int);
extern void addnstr(char *s, int n);
extern void addstr(char *s);

extern void mvaddch(int, int, int);
extern void mvaddnstr(int y, int x, char *s, int n);
extern void mvaddstr(int y, int x, char *s);

extern void scroll(WINDOW * w);

extern void clrtoeol(void);
extern void clrtobot(void);
extern void clear(void);
extern void erase(void);
extern void refresh(void);

extern int getCh(int);
extern char* getstr(char *s);
extern void sys_exit(int);

extern void redraw();
extern void unredraw();

extern WINDOW *newwin(int nlines, int ncols, int begin_y, int begin_x);
extern void delwin(WINDOW *win);
extern void def_prog_mode(void);
extern void reset_prog_mode(void);
extern void wclrtoeol(WINDOW *w);
extern void werase(WINDOW *w);
extern void box(WINDOW *w, int v, int h);
extern void winsertln(WINDOW *w);

extern int skipf;

#define getch() getCh(skipf ? 2 : 0)
#define wgetch(win) getch()
#define erasechar() KEY_BACKSPACE
#define doupdate() refresh()
#define redrawwin(win) redraw()
#define wnoutrefresh(win) redraw()
#define wrefresh(win) refresh()
#define getyx(w, y, x) { y = cursorp_y - w->begin_y; x = cursorp_x - w->begin_x; }
#define getmaxyx(w, y, x) { y = w->nlines; x = w->ncols;}
#define wmove(w,y,x) move(w->begin_y + y, w->begin_x + x)
#define wattron(w,c) attron(c)
#define wattroff(w,c) attroff(c)
#define mvwaddch(w, y, x, c) mvaddch(w->begin_y + y, w->begin_x + x, c)
#define waddch(w, c) addch(c)
#define waddstr(w, s) addstr(s)
#define mvwaddstr(w, y, x, s) mvaddstr(w->begin_y + y, w->begin_x + x, s)

// txplor defs
#define wattrset( win, attr ) attrset(attr)
#define vidattr( attr ) attrset(attr)
#define curs_set {}
#define putp(s) addstr(s)
#define echochar(ch) addch(ch)
#define mvprintw(y,x,s) mvaddstr(y,x,s)
#define clearok(w,f) redraw()
#define leaveok {}
#define typeahead(fd) {}
#define baudrate() QUICK_BAUD_RATE
#define subwin(w,nl,nc,y,x) newwin(nl,nc,y,x)
#define winsertln(w) {}
#define touchwin(w) redraw()

// done xcurses
