
/*
   Four function command line calculator.
   bc.c Copyright (C) March 3, 2004, Terry Loveall <loveall@qwest.net>
   This program is released into the public domain.
   compile with 'gcc bc.c -O2 -Wall -fomit-frame-pointer -o bc;strip bc;ls -al bc'
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// interactive input key validator
char key[20] = { 
	'7',  '8', '9',  '+',
	'4',  '5', '6',  '-',
	'1',  '2', '3',  '*',
	'.',  '0', 'C',  '/',
	'=',  ' ',  '\n', '\0'
};

int main(int argc,char *argv[])
{
	double current = 0;
	int i = -1, b = 0, last = 0;
	char *str = NULL;

	if (argc == 1) {
		str = (char *) malloc(1024);

		i = -1; b = 0; last = 0;
		argv[0] = str;
		b++;
		do {
			i++;
			str[i] = getchar();

			if (str[i] == 'c') str[i] = 'C';
			if (str[i] == '*') str[i] = 'x';
			if(!strchr(key, str[i])) {
				i--; continue;
			}
			str[i+1] = '\0';

			if (str[i] == ' ') {
				last = i+1;
				argv[b] = &str[i + 1];
				str[i] = '\0';
				b++;
			}
		}
		while (str[i] != '\n');
		str[i] = '\0';
		argc = b + 0;
	} else {
		argc--;
		argv = &argv[1];
	}

	for (i = 0; i < argc;) {
		if (argv[i][0] == '+') {
			current += atof(argv[i + 1]);
			i++;
		} else if (argv[i][0] == '-') {
			current = current - atof(argv[i + 1]);
			i++;
		} else if (argv[i][0] == 'x') {
			current = current * atof(argv[i + 1]);
			i++;
		} else if (argv[i][0] == '/') {
			current = current / atof(argv[i + 1]);
			i++;
		}
		else if ('0' <= argv[i][0] < '9') {
			current = atof(argv[i]);
		}
		i++;
	}
	printf("%g\n", current);
	return(0);
}
