#!/bin/sh

. makewoaf-Config

# woaf-ref is source for image
./makeimage

umount mnt 2>/dev/null
gunzip < Image.gz > image
mount -o loop image mnt

echo
echo "File Sizes in Bytes:"
du -bc bzImage Image.gz
echo "1474560 bytes max"
if [ "$DEST_DEV" ] ; then
	echo; echo -n "*** Insert floppy in /dev/fd0 and press [enter]..."
	read DUMMY
	echo

	echo "Writing kernel to floppy..."
	dd if=bzImage of=woafnew.img bs=1k > /tmp/kernsize.mung 2>&1

	rdev woafnew.img /dev/ram0
	rdev -R woafnew.img 0 
if [ -f woaf-ref/usr/X11R6/bin/Xfbdev ];then
	rdev -v woafnew.img -3 # ask for videomode
	echo "Setting rdev VIDEOMODE=-3, 'Ask'."
fi

	cat /tmp/kernsize.mung | while read aa; do
		set $aa
		let r="$1"
		echo "bzImage_size=$r"

		let ddsize="$r + 16384"
		echo "ramdisk_size=$ddsize"
		echo "seek=$r"

		eval rdev -r woafnew.img $ddsize
		eval rdev woafnew.img /dev/fd0

		eval dd if=Image.gz of=woafnew.img bs=1k seek=$r
		eval dd if=woafnew.img of=$DEST_DEV bs=1k
		echo -n "Waiting until everthing is written... "
		sync

		break
	done

fi

echo "done."

if [ "$DEST_DEV" -a "$WERR" = "true" ] ; then
	echo
	echo "*** Maybe an error occurred during writing process:"
	echo "*** try to format devide with  fdformat  and then $0 again."
	echo
elif [ "$DEST_DEV" ] ; then
	umount mnt
	echo
	echo "*** disk written. You can reboot the system with disk in floppy drive."
	echo
else
	echo
	echo "*** image written in file ${DEST_IMG}."
	echo "*** You can put it on a floppy disk using 'dd' or 'cat'."
	if [ $MINOR -ne 0 ] ; then
		echo "*** Probably you need also to execute  fdformat $DEST_DEV  first."
	fi
	echo
fi
