#!/bin/sh
# reserve a 512 MB ram image
dd of=hd.img bs=1024 seek=500000 count=0
# or make a zero filled file to aid compression
dd if=/dev/zero of=hd.img bs=1k count=500000
# mount it for formatting
losetup /dev/loop3 hd.img
# format the damn thing
mkdosfs -F 32 -v hd.img
# unmount the loop device
sync;losetup -d /dev/loop3
# mount it on ./mnt
mount -oloop hd.img mnt
# unmount it from ./mnt
umount mnt

# create a 10M vfat data.img from scratch
dd if=/dev/zero of=data.img bs=1k count=10486
losetup /dev/loop3 data.img
mkdosfs -F 32 -v data.img
sync;losetup -d /dev/loop3

#fdisk and format from a DOS boot floppy with fdisk.exe, format.com and
# sys.com. Must also load a cdrom.sys and MSCDEX.EXE.
qemu -L . -localtime -boot a -fda /dev/fd0 -hda hd.img
# run fdisk and create a primary bootable partition
# run format /S to make it bootable

# to copy DOS files from D: to hd.img using linux with /dev/hda as D::
qemu -L . -localtime -enable-audio -user-net -kernel bzimnm.16m \
-initrd image.gz -append "root=/dev/ram0 rw" -hda hd.img -hdb /dev/hda
#after booting execute the following line to mount hd.img and /dev/hda
#cd /;mkdir /c /d;mount /dev/hda /c;mount /dev/hdb /d;
#copy desired files from /d to /c

# install win98 from CD-ROM into hd.img with /dev/hda as D:
qemu -L . -localtime -enable-audio -user-net -boot c -cdrom /dev/cdrom \
-hda hd.img -hdb /dev/hda

# install win98 from CD-ROM into hd.img without other drives
qemu -L . -localtime -enable-audio -user-net -boot c -cdrom /dev/cdrom \
-hda hd.img

# to run a secure win98 with persistent data storage 
# (all writes are to data.img):
qemu -L . -snapshot -localtime -enable-audio -user-net -boot c -hda hd.img -hdb data.img

# to run a linux kernel and initrd image with /dev/hda available use:
qemu/qemu -L qemu/ -localtime -user-net -kernel bzImage \
-append 'root=/dev/ram0 ro' -initrd Image.gz -hda /dev/hda

# to run a different linux kernel and partition use, e.g.:
qemu/qemu -L qemu/ -localtime -user-net -kernel vmlinuz \
-append "root=/dev/hda7 ro " -hda /dev/hda
#replace 'vmlinux', '/dev/hda7' and '/dev/hda' with your options
