#!/bin/bash
#
# lwm.sh: A >> bash << script to create a Linux initrd with optional X.
REV="24" # May 9,2001
echo "lmw$REV.sh"
# Xvnc version: with modified vnc script from muLinux
#
# Copyright (C) April, 2001 Mike McQuade, Terry Loveall 
#                email: mike@cintras.com, loveall@qwest.net
# Released under GPL 2 with NO WARRANTY, see accompanying GPL doc.
#
# Many thanks to:
#  Michelle Andreoli for muLinux, http://sunsite.dk/mulinux/
#  Aaron Schoenhals for mu2,      http://www.phatboydesigns.net/mu2/index.html
#  Pascal Schmidt   for ttylinux  http://www.informatik.uni-bremen.de/~pharao90/ttylinux/
#
# Perfect elegance in a small OS.
#
# Requires the following:
# tinylogin: http://tinylogin.lineo.com/
# busybox:   http://busybox.lineo.com/
# uClibc:    http://cvs.uclinux.org/uClibc.html
#   After building and installing uClibc, create a symbolic link in /lib:
#    'ln -s ld-2.2.2.so ld-linux.so.1'. 
#
# Recommended:
# e3 editor: http://www.sax.de/~adlibit/
#
# Notes:
#   Included files built with libc-2.2.
#   This script requires uid root to build/boot the initrd properly.
#
####################################################################
# Build target directory and initrd mount point

BUILDIR="target"
MOUNTP="embfiles"

####################################################################
# Uncompressed initrd size in 1024 byte blocks. 
# Use 4096, 8192, 12288, 13312, 16384. I.E. size in Meg x 1024

BLOCKSIZE="12288"

#########################################################################
# Option defines. Uncomment for a non-zero string to enable installation.
# See specific code for details.

#FIREWALL="1"
#THTTPD="1"
GPM="1"
#LDD="1"
REBOOT="1"
#SULOGIN="1"
#STRACE="1"

INSTALL_X="1"
LWM="1"
#GTK="1"
#DILLO="1"
#HELIWM="1"
YCALC="1"
XCRUISE="1"
#BROWSEX_SUP="1"
XENON="1"
XFILEMAN="1"
#VGA16="1"
#FBDEV="1"
XVNC="1"

####################################################################
#
# Start of base system, console and networking setup
#
####################################################################

START_DIR=$(pwd)

####################################################################
#
# Now we make a $BLOCKSIZE file that will be our initrd image.
#
#################################################################### 
   
if [ ! -f newfs ]; then
    dd if=/dev/zero of=newfs bs=1024 count=$BLOCKSIZE
    losetup /dev/loop3 newfs
    mke2fs -qF -m 0 -i 2000 -b 1024 newfs    
    losetup -d /dev/loop3
else
    echo "newfs already exists. Exiting $0"
    exit 1
fi

if [ -d $BUILDIR ]; then
    rm -rf $BUILDIR
fi

echo "Creating buildir '$BUILDIR'."
mkdir $BUILDIR

if [ ! -d $MOUNTP ]; then
    echo Creating mount point directory '$MOUNTP'.
    mkdir $MOUNTP
fi

mount -o loop newfs $MOUNTP

cd $BUILDIR
TOPDIR=$(pwd)

####################################################################
#
# Now make the file system structure.
#
####################################################################

top_dirs=( bin boot dev etc home lib mnt proc root sbin tmp usr var )

index=0
element_count=${#top_dirs[@]}

while [ $index -lt $element_count ]
do
  if [ ! -d $(pwd)'/'${top_dirs[$index]} ]; then
    mkdir ${top_dirs[$index]}
  fi
  let "index = $index + 1"
done

subdirs=( 'usr/bin' 'usr/sbin' 'usr/src' 'usr/local' 'var/lock' 'var/log' \
          'var/run' 'var/tmp' )

index=0
element_count=${#subdirs[@]}

while [ $index -lt $element_count ]
do
  if [ ! -d $(pwd)'/'${subdirs[$index]} ]; then
    mkdir ${subdirs[$index]}
  fi
  let "index = $index + 1"
done

# Brute force. Maybe need a variable loop like the dir creation

chmod 1777 tmp
chmod 1777 var/lock
chmod 1777 var/run

####################################################################
#
# Copy over the device files.
#
# Alternatively:
# mkdir dev;cd dev;cp /dev/MAKEDEV .;./MAKEDEV;cd ..
#
####################################################################

cp -a /dev . 

####################################################################
#
# Check Busybox, if built, then install into the new embedded tree.
#
####################################################################

cd $START_DIR   

if [ -d busybox ]; then
    cd busybox
    if [ -f busybox ]; then
        echo found busybox....
        ./install.sh ../$BUILDIR > /dev/null
    else
        echo Please Build busybox first !
    fi
    cd $TOPDIR

    if [ -f '$BUILDIR/linuxrc' ]; then
        rm linuxrc
    fi
else
  echo "busybox not found. Cannot continue. Exiting $0."
  exit 1
fi

####################################################################
#
# Check Tinylogin, if built, then install into the new embedded tree.
#
####################################################################

cd $START_DIR 

if [ -d tinylogin ]; then
    cd tinylogin
    echo found tinylogin....
    if [ -f tinylogin ]; then
        ./install.sh ../$BUILDIR > /dev/null
    else
        echo "tinylogin found but not built! Cannot continue. Exiting $0."
        exit 1
    fi
else
  echo "tinylogin not found. Cannot continue. Exiting $0."
  exit 1
fi

####################################################################
#
# Copy generic /etc files over from the source tree.
#
####################################################################

cd $TOPDIR

cd etc

etc_files=( group host.conf hosts passwd shadow 'shadow-' \
            inittab issue localtime profile protocols group gshadow \
            rpc securetty services 'resolv.conf' )

index=0
element_count=${#etc_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${etc_files[$index]} ]; then
    cp '/etc/'${etc_files[$index]} .
  fi
  let "index = $index + 1"
done

# Copy for reference purposes during debug
#cp /etc/rc.d/rc.inet* etc/.

# cd back to top dir

cd $TOPDIR

####################################################################
#
# Copy the /bin files over from the source tree.
#
####################################################################

cd bin

bin_files=( bash hostname )

index=0
element_count=${#bin_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${bin_files[$index]} ]; then
    cp -a '/bin/'${bin_files[$index]} .
  fi
  let "index = $index + 1"
done

####################################################################
#
# Soft link sh to bash only if bash exists and sh is not a regular file
#
####################################################################

if [ -x bash ]; then
  if [ -L 'sh' ]; then
    rm -f sh
    echo Removed soft link to sh
  fi
  if [ ! -f 'sh' ]; then
    ln -s bash sh
    echo bash is now sh
  else
    echo sh not a symlink
  fi
else
  echo "bash not installed"
fi

# cd back to top dir

cd $TOPDIR

####################################################################
#
# Copy the /sbin files over from the source tree.
#
####################################################################

cd sbin

if [ -n "$REBOOT" ]; then
    echo "Installing external halt, reboot and shutdown."
    # added halt, reboot and shutdown 'cause busybox segfaults on reboot.
    rm -f halt reboot
    sbin_files=( fsck fsck.ext2 e2fsck hwclock ipchains \
                 ldconfig mkfs 'mklost+found' halt reboot shutdown )
else
    sbin_files=( fsck fsck.ext2 e2fsck hwclock ipchains \
                 ldconfig mkfs 'mklost+found' )
fi

index=0
element_count=${#sbin_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${sbin_files[$index]} ]; then
    cp -a '/sbin/'${sbin_files[$index]} .
  fi
  let "index = $index + 1"
done

cd $TOPDIR

####################################################################
#
# Copy the /usr/sbin files over from the source tree.
#
####################################################################

cd usr/sbin

usr_sbin_files=( chat gpm inetd )

index=0
element_count=${#usr_sbin_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${usr_sbin_files[$index]} ]; then
    cp -a '/usr/sbin/'${usr_sbin_files[$index]} .
  fi
  let "index = $index + 1"
done

cd $TOPDIR

####################################################################
#
# Copy the /usr/bin files over from the source tree.
#
####################################################################

cd bin

usr_bin_files=( ddate script )

index=0
element_count=${#usr_bin_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${usr_bin_files[$index]} ]; then
    cp -a '/usr/bin/'${usr_bin_files[$index]} .
  fi
  let "index = $index + 1"
done

cd $TOPDIR

####################################################################
#
# Copy the /lib files over from the source tree.
#
####################################################################

cd lib


lib_files=( ld-linux.so.2 ld-2.2.2.so libc libcrypt libdl.so.2 libdl-2.2.2.so \
            libnss_dns libnss_files libresolv libutil libtermcap libext2fs \
            libcom_err libuuid )

index=0
element_count=${#lib_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${lib_files[$index]} ]; then
    cp -af '/lib/'${lib_files[$index]}* .
  fi
  let "index = $index + 1"
done

####################################################################
#
# Strip the libs to save space.
#
####################################################################

for file in * ; do
    if [ ! -L $file ]; then
        strip $file
    fi
done

ln -s ld-2.2.2.so ld-linux.so.1

cd $TOPDIR

####################################################################
#
# Install e3 editor
#
####################################################################

if [ -d ../e3-1.4 ]; then
    cd ../e3-1.4
    echo installing e3 editor...
    if [ -f e3 ]; then
        cp e3 $TOPDIR/bin/.
        cd $TOPDIR/bin
        ln -s e3 e3vi
        ln -s e3vi vi
    else
        echo Please build e3 first !
    fi
    cd $TOPDIR
fi

cd $TOPDIR

####################################################################
#
# Customize
# Copy the custom initrd config files, including:
# rc.sysinit, fstab, inittab, profile,
# rc.00.firewall, rc.10.network, rc.20.httpd and rc.30.inetd
#
####################################################################

cp ../init_scripts/etc . -R
cp ../init_scripts/.profile root/.

if [ -n "$FIREWALL" ]; then
    echo "Enabling Firewall script."
    chmod +x etc/rc.d/rc.start/rc.00.firewall # enable paranoia
fi

if [ -n "$THTTPD" ]; then
    echo "Installing and enabling thttpd."
    cp ../init_scripts/thttpd usr/sbin/. # capture the daemon
    chmod +x etc/rc.d/rc.start/rc.20.httpd # turn him on
fi

####################################################################
# You don't use a mouse?!?!
# make a soft link from mouse input device to /dev/mouse
# echo "/usr/sbin/gpm -R -m /dev/mouse -t %s" > etc/rc.d/rc.gpm"
# '%s' in above line is mouse protocol 'msc', 'PS/2', 'Microsoft'...

if [ -n "$GPM" ]; then
  echo "Installing and enabling gpm console mouse."
  echo "echo 'Loading gpm...'" > etc/rc.d/rc.gpm
  # -t PS/2 for laptops
  # echo "/usr/sbin/gpm -R -m /dev/mouse -t PS/2" >> etc/rc.d/rc.gpm
  # -t ms for serial mice
  echo "/usr/sbin/gpm -R -m /dev/mouse -t ms" >> etc/rc.d/rc.gpm
  echo  >> etc/rc.d/rc.gpm
  chmod +x etc/rc.d/rc.gpm
  cd dev
  rm -f mouse
  # ln -s psaux mouse # psaux/ps2aux for laptop
  ln -s ttyS1 mouse # for serial mouse
  cd -
fi

# copy ldd for development use
if [ -n "$LDD" ]; then
  echo "Installing ldd."
  cp /usr/bin/ldd usr/bin/.
fi

# This _is_ GPL.

cp ../$0 etc/lmw$REV.sh

# a touch of creation
touch var/log/messages

# Set hostname to that of the development system
uname -n >etc/HOSTNAME

####################################################################
#
# Give 'em a real sulogin when login doesn't work during passwd testing
#
####################################################################

if [ -n "$SULOGIN" ]; then
    echo "sulogin /dev/console" >> etc/rc.d/rc.sysinit
    echo >> etc/rc.d/rc.sysinit
    rm -f sbin/sulogin
    cp -f /sbin/sulogin sbin/.
fi

####################################################################
#
# strace for debugging
#
####################################################################

if [ -n "$STRACE" ]; then
    echo "Installing strace."
    cp -af /usr/bin/strace usr/bin/.
    cp -af /lib/libnsl* lib/.
fi

####################################################################
#
# End of base system text mode/networking setup
#
####################################################################

cd $START_DIR

####################################################################
#
# Start of X11R6 3.3.x.x (better-be-in-that-range) bash function.
#
####################################################################
InstallX()
{

# Use pre-built skeleton derived from xskel.sh and mu2-X11R6.tgz

if [ -f init_scripts/Xskel.tgz ]; then 
    echo Untaring init_scripts/Xskel.tgz
    cd $BUILDIR
    tar xzf ../init_scripts/Xskel.tgz
    cd -
else
    echo "No init_scripts/Xskel.tgz found! Cannot continue. Exiting $0"
    exit 1
fi
sync

cd $BUILDIR

####################################################################
#
# Copy /usr/X11R6/lib files from source tree.
#
####################################################################

cd usr/X11R6/lib

echo copying X11R6 xlibs

xlib_files=( libICE.so libX11.so libXext.so libXpm.so \
             libSM.so libXaw.so libXmu.so libXi.so libXt.so )

index=0
element_count=${#xlib_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${xlib_files[$index]} ]; then
    cp -af '/usr/X11R6/lib/'${xlib_files[$index]}* .
  fi
  let "index = $index + 1"
done

####################################################################
#
# Copy the /usr/lib grpahic image files from the source tree.
#
####################################################################

echo copying source xglibs

xglib_files=( libjpeg.so libtiff.so libpng.so libungif.so \
              libstdc++-libc6.2-2.so.3 libstdc++-3-libc6.2-2-2.10.0.so )

index=0
element_count=${#xglib_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${xglib_files[$index]} ]; then
    cp -af '/usr/lib/'${xglib_files[$index]}* .
  fi
  let "index = $index + 1"
done

####################################################################
#
# Strip symbols from graphic libs.
#
####################################################################

echo stripping xlibs

for file in * ; do
    if [ ! -L $file ] && [ ! -d $file ]; then
        strip $file
    fi
done

cd $TOPDIR

####################################################################
#
# Copy /usr/X11R6/bin files from source tree.
#
####################################################################

cd usr/X11R6/bin

echo copying X11R6 bins

if [ -n "$YCALC" ]; then
  xbin_files=( rxvt xauth xclock xdm xf86config xhost \
               xinit xload xmodmap xrdb xset xsetroot xwd )
else
  xbin_files=( rxvt xauth xcalc xclock xdm xf86config xhost \
               xinit xload xmodmap xrdb xset xsetroot xwd )
fi

index=0
element_count=${#xbin_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${xbin_files[$index]} ]; then
    cp -af '/usr/X11R6/bin/'${xbin_files[$index]}* .
  fi
  let "index = $index + 1"
done

####################################################################
#
# Strip xbins.
#
####################################################################

echo stripping xbins

for file in * ; do
    if [ ! -L $file ] && [ ! -d $file ]; then
        strip $file
    fi
done

cd $TOPDIR

####################################################################
#
# Copy the GTk+ lib files from the source tree.
#
####################################################################

if [ -n "$GTK" ]; then
  cd usr/X11R6/lib

  echo copying source GTk libs

  gtklib_files=( libgdk*so* libglib*so* libgmodule*so* libgthread*so* libgtk*so* )

  index=0
  element_count=${#gtklib_files[@]}

  while [ $index -lt $element_count ]
  do
    if [ ! -f $(pwd)'/'${gtklib_files[$index]} ]; then
      cp -af '/usr/lib/'${gtklib_files[$index]}* .
    fi
    let "index = $index + 1"
  done

  cd $TOPDIR
fi

####################################################################
#
# Option to add the dillo GTk based web browser and support libs.
#
####################################################################

if [ -n "$DILLO" ]; then
  echo "Copying libpthreads."
  cp -a /lib/libpthread* lib/.
  echo "Copying libz."
  cp -a /usr/lib/libz.so* usr/lib/.
  echo "Copying Dillo."
  cp /usr/local/bin/dillo usr/X11R6/bin/.
  cp -P /root/.dillo/dillorc .
  sync
fi

####################################################################
#
# Copy selected /usr/X11R6/lib/X11/app-defaults.
#
####################################################################

cd usr/X11R6/lib/X11/app-defaults

echo copying selected source X app-defaults

if [ -n "$YCALC" ]; then
  xapd_files=( XCalc XCalc-color XClock XLoad )
else
  xapd_files=( XClock XLoad )
fi

index=0
element_count=${#xapd_files[@]}

while [ $index -lt $element_count ]
do
  if [ ! -f $(pwd)'/'${xapd_files[$index]} ]; then
    cp -af '/usr/X11R6/lib/X11/app-defaults/'${xapd_files[$index]}* .
  fi
  let "index = $index + 1"
done

cd $TOPDIR

####################################################################
#
# Copy X11R6 custom specifics
#
####################################################################

# Copy peculiar linked libm
cd lib
cp /lib/libm-2.2.2.so .
ln -s libm-2.2.2.so libm.so.6
cd -

# Setup X config. Customize to fit your needs
mkdir usr/X11R6/lib/X11/xinit

# Use source config for baseline
cp /usr/X11R6/lib/X11/XKeysymDB usr/X11R6/lib/X11/.
cp /usr/X11R6/lib/X11/rgb.txt usr/X11R6/lib/X11/.
cp /usr/X11R6/lib/X11/xserver/SecurityPolicy usr/X11R6/lib/X11/xserver/.

# Use dev system defaults for now.
cp /usr/X11R6/lib/X11/xinit/.Xresources usr/X11R6/lib/X11/xinit/.

# The following makes Backspace key usable under X
cp ../init_scripts/x11/.Xmodmap usr/X11R6/lib/X11/xinit/.

# XF86_VGA16 server.
if [ -n "$VGA16" ]; then
  echo Installing XF86_VGA16.3.3.6 as X server
  cp ../init_scripts/x11/startx usr/X11R6/bin/.
  cp ../init_scripts/x11/XF86Config.3.3.6 etc/XF86Config
  cp ../init_scripts/x11/XF86_VGA16.3.3.6 usr/X11R6/bin/XF86_VGA16
  cd usr/X11R6/bin/
  ln -s XF86_VGA16 X
  cd -
fi

# Selected X Server

# XF86_FBDev server.
if [ -n "$FBDEV" ]; then
  echo Installing XF86_FBDev as X server
  cp ../init_scripts/x11/startx usr/X11R6/bin/.
  cp ../init_scripts/x11/XF86Config.FBDev etc/XF86Config
  cp -a /d/linux/usr/X11R6/bin/XF86_FBDev usr/X11R6/bin/.
  cd usr/X11R6/bin/
  ln -s XF86_FBDev X
  cd -
fi

# Xvnc server.
if [ -n "$XVNC" ]; then
  echo Installing Xvnc as X server
  cp ../init_scripts/x11/XF86Config.FBDev etc/XF86Config 
  cp ../init_scripts/x11/Xvnc usr/X11R6/bin/. #the server
  cp ../init_scripts/x11/vnc* usr/X11R6/bin/. #support
  cp -a ../init_scripts/.vnc root/.
  echo Creating Xvnc vncserver script.
  echo "echo 'Starting Xvnc server...'" > usr/X11R6/bin/vncserver
  echo "echo \"use: \"\'nvnc stop\'\" to quit X.\"" >> usr/X11R6/bin/vncserver
  echo "vnc start" >> usr/X11R6/bin/vncserver
  echo  >> usr/X11R6/bin/vncserver
  chmod +x usr/X11R6/bin/vncserver
fi

# xinitrc soft-linked to selected wm
cp -a ../init_scripts/x11/xinitrc* usr/X11R6/lib/X11/xinit/.

# lwm X window manager
if [ -n "$LWM" ]; then
  echo "Installing lwm, a mouse oriented wm w/o rc."
  cp ../init_scripts/x11/lwm usr/X11R6/bin/.
  cd usr/X11R6/lib/X11/xinit/; ln -s xinitrc.lwm xinitrc;cd -
  cp ../init_scripts/x11/lwm.txt .
fi

# heliwm X window manager
if [ -n "$HELIWM" ]; then
  echo "Installing heliwm, keyboard oriented wm w/rc in home dir."
  cp ../init_scripts/x11/heliwm usr/X11R6/bin/.
  cd usr/X11R6/lib/X11/xinit/; ln -s xinitrc.heliwm xinitrc;cd -
  cp ../init_scripts/x11/.heliwmrc root/.
  cp ../init_scripts/x11/heliwm.txt .
fi

# script to make rxvt look (sorta) like xterm
cp ../init_scripts/x11/xterm usr/X11R6/bin/.

# TI-59 ycalc with dec/hex/oct/bin conversion
if [ -n "$YCALC" ]; then
  echo "Copying ycalc"
  cp ../init_scripts/x11/ycalc usr/X11R6/bin/.
  cp ../init_scripts/x11/ycalc.txt .
fi

# A cool X directory viewer.
if [ -n "$XCRUISE" ]; then
  echo xcruise Eye Candy, a different way of seeing the file system
  cp ../init_scripts/x11/xcruise usr/X11R6/bin/.
  cp ../init_scripts/x11/xc usr/X11R6/bin/. # simple xcruise startup
  cp ../init_scripts/x11/xcruise.txt .
fi

# BrowseX support data base libs.
if [ -n "$BROWSEX_SUP" ]; then
  echo Data Base libs for e.g. BrowseX
  cp -a /usr/lib/libgdbm.* usr/lib/.
fi

# Quasi-modern X text editor.
if [ -n "$XENON" ]; then
  echo "xenon X text editor."
  cp ../init_scripts/x11/xe usr/X11R6/bin/.
  cp ../init_scripts/x11/.xerc root/.
  cd usr/X11R6/bin/; ln -s xe xedit;cd -
  cp -af ../init_scripts/x11/75dpi/* usr/X11R6/lib/X11/fonts/75dpi/.
fi

# Old school X filemanager
if [ -n "$XFILEMAN" ]; then
  echo "xfilemanager: cheap Explorer clone."
  cp ../init_scripts/x11/xfilemanager usr/X11R6/bin/.
  cp ../init_scripts/x11/xfm usr/X11R6/bin/. # simple xfilemanager start script
  cp ../init_scripts/x11/xfilemanager.txt . # man page in txt format
  cp ../init_scripts/x11/Cmnd usr/X11R6/bin/. # rxvt shell script
  mkdir -p usr/local/lib
  cp -a ../init_scripts/xfilemanager usr/local/lib/. #system defaults
fi

}
# end of InstallX function

if [ -n "$INSTALL_X" ]; then
  InstallX
else
  echo "X-windows NOT installed"
fi

####################################################################
#
# End of X11R6 3.3.x.x extension.
#
####################################################################

cd $START_DIR   

# out of compassion for:
cp init_scripts/README.txt $BUILDIR/.

# Copy target directory to newfs initrd image
echo "Copying builddir '$BUILDIR' to mountpoint '$MOUNTP'"
mv $BUILDIR/* $MOUNTP/.

# Non-destructively make newfs.gz
umount $MOUNTP
sync
if [ -f newfs.gz ]; then 
  echo newfs.gz already exists. NOT creating initrd!
else
  echo Please wait. Creating and compressing initrd file newfs.gz...
  gzip -9 < newfs > newfs.gz
fi
mount -o loop newfs $MOUNTP
echo Copying this script to $HOME/lmw$REV.sh
cp $0 ~/lmw$REV.sh
#rm -f init_scripts/lmw*
cp $0 init_scripts/lmw$REV.sh

