#!/bin/bash
#
# xskel.sh: An automated way to create a minimal Slackware tree with X.
# Rev 0.01
# Thnaks Michele Andreoli for muLinux, and Aaron Schoenhals for mu2.
# Perfect elegance in a small OS.
#

START_DIR=$(pwd)
  
####################################################################
#
# First we make a 16MB file that will be our initrd image.
#
#################################################################### 
   
if [ ! -f newfs ]; then
    dd if=/dev/zero of=newfs bs=1024 count=16384
    losetup /dev/loop3 newfs
    mke2fs -qF -m 0 -i 2000 -b 1024 newfs    
    losetup -d /dev/loop3
fi

if [ ! -d embfiles ]; then
    mkdir embfiles
fi

mount -o loop newfs embfiles

cd embfiles
TOPDIR=$(pwd)

####################################################################
#
# Untar the mu2 reference X11R6 archive
#
####################################################################

if [ -f /d/linux/mu2/mu2-X11R6.tgz ]; then 
  echo Untaring /d/linux/mu2/mu2-X11R6.tgz
  tar xzvf /d/linux/mu2/mu2-X11R6.tgz > ../xlist.txt
fi
sync

####################################################################
#
# Delete libs from usr/X11R6/lib
#
####################################################################

cd usr/X11R6/lib

echo removing old X11 libs
rm -f * 2> /dev/null

cd $TOPDIR

####################################################################
#
# Delete binaries from usr/X11R6/bin
#
####################################################################

cd usr/X11R6/bin

echo removing old X11 bins
rm -f *

cd $TOPDIR

####################################################################
#
# Replace /usr/X11R6/lib/X11/app-defaults with resident versions.
#
####################################################################

cd usr/X11R6/lib/X11/app-defaults

echo removing old X11 defaults
rm -f *

cd $TOPDIR

####################################################################
#
# Remove unnecessary X components
#
####################################################################

rm  -f usr/X11R6/lib/X11/bitmaps
rm  -f usr/X11R6/lib/X11/pixmaps
rm -rf usr/X11R6/lib/X11/images
rm -rf usr/X11R6/lib/X11/mini-icons
rm -rf usr/X11R6/lib/X11/xkb
rm -rf usr/X11R6/lib/X11/locale
rm  -f usr/X11R6/lib/X11/XKeysymDB
rm  -f usr/X11R6/lib/X11/rgb.txt
rm  -f usr/X11R6/lib/X11/xserver/*
rm  -f etc/rxvt.conf
rm -rf etc/mu2 

# Non-destructively make newfs.gz
echo Creating initrd file newfs.gz...
cd $START_DIR
echo Creating Xskel.tgz. Requires atool: http://www.student.lu.se/~nbi98oli/
atool -a Xskel.tgz embfiles/* 1> xskel.txt
echo Copying this script to $HOME/$0
cp $0 ~/.
