//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeWindow.h,v 1.4 1999/07/18 10:35:10 ben Exp $

#ifndef _XeWindow_H_
#define _XeWindow_H_

//
// This is the base class for all top-level shells... could derive
// dialog boxes from this class too..
//

#include <XeObject.h>
#include <XeKeyTable.h>

#include <X11/Xutil.h>

class XeWindow : public XeObject {
public:
	enum WType { XE_WINDOW, XE_DIALOG };
	
    XeWindow(const char* name, const char* title, 
    		const char* className = "Window");
    virtual ~XeWindow(void);
    
    virtual int	    doEvent(XEvent *theEvent);
    virtual void	takeFocus(bool focus);    
    virtual void	closeEvent(void);
    
    virtual	XeWindow::WType windowType(void);
    
    void	raise(void)
    			{ XMapRaised(gDisplay, _window); }
    
    void	setTitleName(char *title);
    void	setIconName(char *iconName);
    void	setFocusWindow(XeObject* ob);
    void	setIcon(char** iconData);
    
    virtual void	setXFocusWindow(bool);

    void	setNormalHints(XSizeHints*);
    void	setSize(int widthInc, int heightInc, int baseWidth, int baseHeight);
    
    XeObject*	getFocusWindow(void) { return _focusWindow; }
        
    virtual int invokeCommand(KeySym key, uint modifiers);
    virtual int	addKeyBinding(XeObject* ob, KeySym key, uint modifiers);
    
protected:
	
	XeKeyTable	_keyTable;
	XeObject*	_focusWindow;
	
	static XeWindow*	_xfocusWindow;
	
    virtual void	doResize(uint width, uint height);
    virtual void    doMove(int x, int y);
    virtual void	doReconfigure(void);

    void	setResources(void);
    void	doEnter(XEnterWindowEvent* event);
    void	doLeave(XLeaveWindowEvent* event);
    void	doFocusIn(XFocusChangeEvent* event);
    void	doFocusOut(XFocusChangeEvent* event);
};

#endif
