//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeWidget.h,v 1.3 1999/07/18 10:32:00 ben Exp $

#ifndef _XeWidget_H_
#define _XeWidget_H_

#include <XeObject.h>

class XeWidget : public XeObject {
public:
	XeWidget(XeObject* parent, const char* name, 
					const char* className="Widget");
	virtual ~XeWidget(void);
		
	virtual int	    doEvent(XEvent *theEvent);

    virtual int commandKey(KeySym , uint ) { return 0; }
    int	setKeyBinding(KeySym key, uint modifiers=0L);
    
    virtual void	doShow(void);

    virtual void	getResources();
    
    // Set Functions:
    void	setForeground(ulong col);
    void	setFont(const char* fontName);

    
protected:
	GC				_textGC;
	ulong			_textCol;
	
	XFontStruct*	_font;
	
    virtual void	doResize(uint width, uint height);
    virtual void    doMove(int x, int y);
    virtual void	doReconfigure(void);
    
};

#endif
