//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeWidget.C,v 1.4 1999/11/09 07:11:24 ben Exp $

#include <XeWidget.h>
#include <XeApp.h>

#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

XeWidget::XeWidget(XeObject* parent, const char* name, const char* className) :
	XeObject(parent, name, className)
{
	char *fontname = "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*";
        
    XeWidget::setFont(fontname);
	_textCol = BlackPixel(gDisplay, gScreenNum);

	// $$$ may not need to do this
	XeWidget::doShow();
		
	//
	// Philosophy: Select _no_ event masks since this can be done by
	//  a derived class. Also if a widget class is instantiated directly
	//  the XE_CB_XEVENT callback can be registered, in which case
	//  pregnant pause...
	//
	
}

XeWidget::~XeWidget(void)
{
	
}

int
XeWidget::doEvent(XEvent* theEvent)
{
	//
	// Any event that comes thru here activates the XE_CB_XEVENT
	// callbacks that are registered.
	
	callCallbacks(XE_CB_XEVENT, theEvent);
	return 0;
}

void
XeWidget::doResize(uint width, uint height)
{
	if (width == _width && height == _height)
		return;

	XResizeWindow(gDisplay, _window, width, height);
	
	// Virtual function call:
	resizeEvent(width, height);
	
	_width = width;
	_height = height;
	
	callCallbacks(XE_CB_RESIZE, NULL);
}

void
XeWidget::doMove(int x, int y)
{
	if (x == _x && y == _y)
		return;
	
	XMoveWindow(gDisplay, _window, x, y);
	_x = x;
	_y = y;
}

void
XeWidget::doReconfigure(void)
{
	XMoveResizeWindow(gDisplay, _window, _x, _y, _width, _height);
	
	// Virtual function call:
	resizeEvent(_width, _height);
	
	callCallbacks(XE_CB_RESIZE, NULL);
}

void
XeWidget::doShow()
{
	if (!_neverMapped)
		return;
		
	XGCValues values;
	ulong valuemask;
	
	valuemask = GCForeground | GCBackground | GCFont;
	values.font = _font->fid;
	values.foreground = _textCol;
	values.background = _background;
	_textGC = getGC(this, &values, valuemask);
}

// This should be set after calling setFont()

void
XeWidget::setForeground(ulong col)
{
	_textCol = col;
}

void
XeWidget::setFont(const char* fontname)
{	
	// Get a font from the local font cache.
	_font = getFont(fontname);
	
	if(!_font) {
		// exit for now with error message..
		fprintf(stderr, "%s: XeWidget::setFont Cannot open font %s.\n", 
		 	gProgname, fontname);
		exit(1);
	}
	
#if 0
	XGCValues values;
	ulong valuemask;
	
	valuemask = GCForeground | GCFont;
	values.foreground = _textCol;
	values.font = _font->fid;
	_textGC = getGC(this, &values, valuemask);
#endif
}

int
XeWidget::setKeyBinding(KeySym key, uint modifiers)
{
	return _base->addKeyBinding(this, key, modifiers);
}

void
XeWidget::getResources()
{
	XeObject::getResources();
	
	XrmValue value;

	if (getResource("foreground", "foreground", &value))
		setForeground(lookupColour(this, value.addr));
}
