//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeToggle.h,v 1.1 1996/11/17 09:53:31 ben Exp $

#ifndef _XeToggle_H_
#define _XeToggle_H_

#include <XeLabel.h>

class XeToggle : public XeLabel {
public:
	enum ToggleType {
		XE_RADIO,
		XE_TOGGLE
	};
	
	XeToggle(XeObject *parent, const char* name, 
		const char* className = "Toggle");
	~XeToggle(void);

	int		doEvent(XEvent* theEvent);
	
	void	setLabel(const char* label);
	void	setType(ToggleType type) { _type = type; }
	void	setState(bool state);
	
	bool	getState(void) { return _toggleState; }

private:
	GC		_shadowGC, _rshadowGC, _hiliteGC, _backGC;
	bool	_inButton, _toggleState;
	ToggleType	_type;
	
    void doButton(XButtonEvent *);
    void doMotion(XMotionEvent *);
    
    void hilite(bool state, bool fromExpose=FALSE);
    void drawDiamond(XRectangle& r, bool state);
};

#endif
