//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeTextKeys.h,v 1.3 1999/07/18 10:35:45 ben Exp $

#ifndef _XeTextKeys_H_
#define _XeTextKeys_H_

#include <XeKeyTable.h>

class XeText;

class XeTextKeys {
	struct KeyOpMap {
		const char* name;
		KeyFunc	op;
		KeySym defaultKey;
		uint defaultModifiers;
	};
	
	static KeyOpMap _mappings[];
	
	static int	getNumOps(void);
	
	static void up(XeText*);
	static void down(XeText*);
	static void left(XeText*);
	static void right(XeText*);
	static void extend_up(XeText*);
	static void extend_down(XeText*);
	static void extend_left(XeText*);
	static void extend_right(XeText*);
	static void prev_word(XeText*);
	static void next_word(XeText*);
	static void extend_prev_word(XeText*);
	static void extend_next_word(XeText*);
	static void start_line(XeText*);
	static void end_line(XeText*);
	static void extend_start_line(XeText*);
	static void extend_end_line(XeText*);
	
	static void page_up(XeText*);
	static void page_down(XeText*);
	static void home(XeText*);
	static void end(XeText*);
	
	static void delete_right(XeText*);
	
	friend class XeText;
};

#endif
