//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeTextField.h,v 1.3 1999/11/09 07:16:55 ben Exp $

#ifndef _XeTextField_H_
#define _XeTextField_H_

#include <XeTextBase.h>

class XeTextField : public XeTextBase {
public:
	XeTextField(XeObject *parent, const char *name,
		const char* className = "TextField");
	virtual ~XeTextField();
	
	virtual int		doEvent(XEvent *theEvent);
	virtual void	selectionNotify(char* data, int len);
	virtual	void	selectionClear(void);
	
	void	setString(const char*);
	void	selectAll();
	
private:
	enum ScrollSide { Left, Right };
	
	int		_lastCol;
	char*	_cutBuffer;
	bool	_doingPaste;
	
	void	doKey(XKeyEvent* event);
	void	doButton(XButtonEvent* event);
	void	doMotion(XMotionEvent* event);
	
	void	dragAround(XMotionEvent *event);
	void	dragSelect(XMotionEvent *event);
	void	autoMotionScroll(XMotionEvent *event, bool paste=FALSE);
	
	void	doArrow(XKeyEvent* event, KeySym key);
	
	void	xpaste(void);
	void	doPaste(char* data, int len);
};

#endif
