//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeSpList.h,v 1.1 1996/11/17 09:46:41 ben Exp $

#ifndef _XeSpList_H_
#define _XeSpList_H_

#include <Xe.h>
#include <XeMiniAlloc.h>

class SpListNode {
private:
	XE_MINIALLOC(0);
	
	SpListNode(void* d) : _data(d) { _next = NULL; };
	
	SpListNode*		_next;
	void*			_data;
	
	friend class XeSpList;
	friend class XeSpListIterator;
};
	
class XeSpList {
public:
	XeSpList(void);
	~XeSpList(void);
	
	void	clear(void);
	void	add(void* data);
	void	append(void* data);
	
	void	remove(void);
	void	chop(void);
	bool	remove(void* data);
	
	int		find(void* data);
	
	int		getSize() { return _items; }
	void*	head(void) { return (_head) ? _head->_data : NULL; }
	void*	tail(void) { return (_tail) ? _tail->_data : NULL; }
	
private:
	SpListNode*	_head;
	SpListNode*	_tail;
	
	int			_items;
	
	friend class XeSpListIterator;
};

class XeSpListIterator {
public:
	XeSpListIterator(XeSpList* list) :
		_list(list) { _index = _list->_head; }
	
	bool	next(void);	
	void*	item(void) { return (_index) ? _index->_data : NULL; }
	void	reset(void) { _index = _list->_head; }
	
private:
	XeSpList*	_list;
	SpListNode*	_index;
	
};

#endif
