//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeSpList.C,v 1.1 1996/11/17 09:46:41 ben Exp $

#include <XeSpList.h>

XeSpList::XeSpList(void)
{
	_head = _tail = NULL;
	_items = 0;
}

XeSpList::~XeSpList(void)
{
	SpListNode*	temp;
	
	while((temp = _head)) {
		_head = _head->_next;
		delete temp;
	}
}

void
XeSpList::clear(void)
{
	SpListNode*	temp;
	
	while((temp = _head)) {
		_head = _head->_next;
		delete temp;
	}
	_head = _tail = NULL;
	_items = 0;
}

void
XeSpList::add(void* data)
{
	SpListNode* temp = new SpListNode(data);
	
	if(_head) {
		temp->_next = _head;
	}
	_head = temp;
	
	if(!_tail)
		_tail = temp;
	
	_items++;
}

void
XeSpList::append(void* data)
{
	SpListNode* temp = new SpListNode(data);
	
	if(_tail) {
		_tail->_next = temp;
	}
	_tail = temp;
	
	if(!_head)
		_head = temp;
	
	_items++;
}

void
XeSpList::remove(void)
{
	if(_head) {
		SpListNode* temp = _head;
		
		_head = _head->_next;
		
		if(!_head)
			_tail = NULL;
		
		delete temp;
		_items--;
	}
}

void
XeSpList::chop(void)
{
	SpListNode* temp = _head;
	SpListNode* curr = NULL;
	
	if(!temp)
		return;
		
	while(temp->_next) {
		curr = temp;	
		temp = temp->_next;
	}
	
	delete temp;
	
	_tail = curr;
	if(!_tail)
		_head = NULL;
	else
		_tail->_next = NULL;
	
	_items--;
}

bool
XeSpList::remove(void* data)
{
	SpListNode* temp = _head;
	SpListNode* prev = NULL;
	
	while(temp) {
		if(data == temp->_data) {
			if(!prev) {
				_head = temp->_next;
				if(!_head)
					_tail = NULL;
			} else {
				if(!temp->_next)
					_tail = prev;
				prev->_next = temp->_next;
				
			}
			delete temp;
			_items--;
			return TRUE;
		} else {
			prev = temp;
			temp = temp->_next;
		}
	}
	return FALSE;
}

int
XeSpList::find(void* data)
{
	SpListNode* temp = _head;
	int i = 0;
	
	while(temp) {
		if(data == temp->_data) {
			return i;
		}
		i++;
		temp = temp->_next;
	}
	return -1;
}

bool
XeSpListIterator::next(void)
{
	if(!_index)
		return FALSE;
	//if(_index->_next == NULL)
	//	return FALSE;
	
	_index = _index->_next;
	return TRUE;
}
