//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeScrollBar.h,v 1.1 1996/11/17 09:46:20 ben Exp $

#ifndef _XeScrollBar_H_
#define _XeScrollBar_H_

#include <XeWidget.h>

class XeScrollBar : public XeWidget {
public:
	XeScrollBar(XeObject *parent, const char* name, 
			const char* className = "ScrollBar");
	virtual ~XeScrollBar();
	    
    int	    doEvent(XEvent *theEvent);
    void	doUpdate(void);
    void	resizeEvent(uint width, uint height);
    
	virtual int commandKey(KeySym key, uint modifiers);
	
	void setMax(long max);
	void setVisibleRange(long range);
	void setPosition(long position, bool updateNow=FALSE);
	
	//void setPos(long position) { _position = position; }
	
	long getMax() { return _max; }
	long getPosition() { return _position; }
    
private:
	GC	_shadowGC, _rshadowGC, _hiliteGC, _faceGC;
	int _shadowWidth, _borderWidth;
	
	long _min, _max, _position;
	long _visRange;
	
	double _fdiff;
	int _sliderGrab, _sliderPosition, _sliderSize, _diff;
	int _oldPos, _oldSize;
	bool _svisible;
	
	void doExpose(XExposeEvent *);
	void doButton(XButtonEvent *);
	void doMotion(XMotionEvent *);
	
	void adjust(bool doUpdate=TRUE);
	void drawSlider(void);
	void clearSlider(int oldpos, int oldsize);
	void moveSlider(int oldpos, int newpos);
	void resizeSlider(int oldsize, int newsize);
	void clipBounds(int oldpos, int oldsize);
	
	void	setResources(void);	
};

#endif
