//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XePromptDialog.h,v 1.2 1999/07/18 10:34:28 ben Exp $

#ifndef _XePromptDialog_H_
#define _XePromptDialog_H_

#include <XeDialog.h>

class XeLabel;
class XeButton;

class XePromptDialog : public XeDialog {
public:
	XePromptDialog(XeWindow* parent, const char* name, const char* title,
		const char* className = "PromptDialog");
	virtual ~XePromptDialog(void);
	
	void	setMessage(const char*);
	
private:
	XeLabel*	_message;
	
	XeButton*	_okButton;
	XeButton*	_cancelButton;
	
	void		buttonCB(const void*);
};

class XeMessageDialog : public XeDialog {
public:
	XeMessageDialog(XeWindow* parent, const char* name, const char* title,
		const char* className = "PromptDialog");
	virtual ~XeMessageDialog(void);
	
	void	setMessage(const char*);

private:
	XeLabel*	_message;
	
	XeButton*	_okButton;
	
	void		buttonCB(const void*);
};

#endif
