#include <XePromptDialog.h>

#include <XeLabel.h>
#include <XeButton.h>

#include <X11/keysym.h>

#define MESSAGE_WIDTH	250
#define MESSAGE_HEIGHT	60

#define VBORDER		5
#define HBORDER		5

XePromptDialog::XePromptDialog(XeWindow* parent, const char* name , const char* title,
	const char* className)
	: XeDialog(parent, name, title, className)
{
	// $$$ eventually this will be an autosizing label that is positioned
	// depending on how big it is as a result of the new message string.
	// the whole dialog box will then be resized accordingly.
	
	_message = new XeLabel(this, "label");
	_message->setAutoSize(FALSE);
	_message->setJustify(XeLabel::XE_JUSTIFY_CENTRE);
	_message->move(VBORDER, HBORDER);
	_message->resize(MESSAGE_WIDTH, MESSAGE_HEIGHT);
	_message->show();
	
	_cancelButton = new XeButton(this, "cancelButton");
	_cancelButton->setAutoSize(TRUE);
	_cancelButton->setLabel("No");
	_cancelButton->addCallback(KrPMF<XePromptDialog>(&XePromptDialog::buttonCB, this), XE_CB_ACTIVATE);
	
	//_cancelButton->move(_message->x() + _message->width() - _cancelButton->width(),
	//		_message->y() + _message->height() + 5);
	
	_cancelButton->resize(_cancelButton->width() + 15, _cancelButton->height());
	_cancelButton->move(HBORDER, _message->y() + _message->height() + 5);
	_cancelButton->show();
	
	_okButton = new XeButton(this, "okButton");
	_okButton->setAutoSize(FALSE);
	_okButton->setLabel("Yes");
	_okButton->addCallback(KrPMF<XePromptDialog>(&XePromptDialog::buttonCB, this), XE_CB_ACTIVATE);
	_okButton->setXBorderWidth(2);
	_okButton->resize(_cancelButton->width(), _cancelButton->height());
	_okButton->move(_message->x() + _message->width() - _okButton->width() - _okButton->borderWidth(),
			_cancelButton->y() - _okButton->borderWidth());
	_okButton->show();
	
	addKeyBinding(_cancelButton, XK_Escape, 0L);
	addKeyBinding(_okButton, XK_Return, 0L);
	addKeyBinding(_okButton, XK_KP_Enter, 0L);
	
	XeWindow::resize(_message->x() + _message->width() + HBORDER,
		_cancelButton->y() + _cancelButton->height() + VBORDER);
}

XePromptDialog::~XePromptDialog(void)
{
	delete _message;
	delete _okButton;
	delete _cancelButton;
}

void
XePromptDialog::setMessage(const char* msg)
{
	_message->setLabel(msg);
}

void
XePromptDialog::buttonCB(const void* data)
{
	XeObject::CBData* cbdata = (XeObject::CBData*)data;	
    bool result = FALSE;
    
    if (cbdata->ob == _okButton)
    	result = TRUE;
    
	hide();
	callCallbacks(XE_CB_ACTIVATE, &result);
}

////////////////////////////////////////////////////////////////////////////////

XeMessageDialog::XeMessageDialog(XeWindow* parent, const char* name , const char* title,
	const char* className)
	: XeDialog(parent, name, title, className)
{
	// $$$ eventually this will be an autosizing label that is positioned
	// depending on how big it is as a result of the new message string.
	// the whole dialog box will then be resized accordingly.
	
	_message = new XeLabel(this, "label");
	_message->setAutoSize(FALSE);
	_message->setJustify(XeLabel::XE_JUSTIFY_CENTRE);
	_message->move(VBORDER, HBORDER);
	_message->resize(MESSAGE_WIDTH, MESSAGE_HEIGHT);
	_message->show();
		
	_okButton = new XeButton(this, "okButton");
	_okButton->setLabel("Ok");
	_okButton->setXBorderWidth(2);
	_okButton->addCallback(KrPMF<XeMessageDialog>(&XeMessageDialog::buttonCB, this), XE_CB_ACTIVATE);
	//_okButton->resize(_okButton->width() + 15, _okButton->height());
	_okButton->move(_message->x() + 
			_message->width() / 2 - 
			(_okButton->width() + _okButton->borderWidth()*2) / 2,
			_message->y() + _message->height() + VBORDER);
			
	_okButton->show();
	
	addKeyBinding(_okButton, XK_Return, 0L);
	addKeyBinding(_okButton, XK_KP_Enter, 0L);
	
	XeWindow::resize(_message->x() + _message->width() + HBORDER,
		_okButton->y() + _okButton->height() + _okButton->borderWidth()*2 + VBORDER);
	
	// $$$ hack to make window appear in the right place before the event loop
	// begins
	
	_width = _message->x() + _message->width() + HBORDER;
	_height = _okButton->y() + _okButton->height() + _okButton->borderWidth()*2 + VBORDER;
}

XeMessageDialog::~XeMessageDialog(void)
{
	delete _message;
	delete _okButton;
}

void
XeMessageDialog::setMessage(const char* msg)
{
	_message->setLabel(msg);
}

void
XeMessageDialog::buttonCB(const void*)
{
	hide();
	bool result = TRUE;
	callCallbacks(XE_CB_ACTIVATE, &result);
}
