//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeProgressBar.h,v 1.2 1998/10/12 02:23:59 ben Exp $

#ifndef _XeProgressBar_H_
#define _XeProgressBar_H_

#include <XeWidget.h>

class XeProgressBar : public XeWidget {
public:
	XeProgressBar(XeObject* parent, const char* name,
			const char* className = "ProgressBar");
	virtual ~XeProgressBar();
	
	int		doEvent(XEvent* event);
		
	// Set functions:
	void	setBorderWidth(int width)
				{ _borderWidth = width; }
	
	
	void	setMax(double max)
				{ _max = max; }
	double	getMax(void)
				{ return _max; }
							
	void	setPosition(double pos);
	double	getPosition(void)
				{ return _position; }
	
private:
	GC		_barGC,	_rshadowGC, _shadowGC;
	int		_borderWidth;
	
	uint	_pixelPosition;
	double	_position;
	double	_max;
	
	void doExpose(XExposeEvent* event);
	void fillBar(void);
};

#endif
