//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeProgressBar.C,v 1.2 1998/10/12 02:23:59 ben Exp $

#include <XeProgressBar.h>
#include <XeApp.h>

#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

XeProgressBar::XeProgressBar(XeObject *parent, const char* name, const char* className) :
	XeWidget(parent, name, className)
{
	_position = 0;
	_pixelPosition = 0;
	_max = 1.0;
	_borderWidth = 3;
	
	XGCValues values;
	ulong valmask;
	
	valmask = GCForeground;
	values.foreground = lookupColour(this, "DarkBlue");
	_barGC = getGC(this, &values, valmask);
	
	values.foreground = lookupColour(this, "grey90");
	_rshadowGC = getGC(this, &values, valmask);
	
	values.foreground = lookupColour(this, "grey40");
	_shadowGC = getGC(this, &values, valmask);
	    
    XSelectInput(gDisplay, _window, ExposureMask);
}

XeProgressBar::~XeProgressBar()
{
}

int
XeProgressBar::doEvent(XEvent* theEvent)
{
    switch(theEvent->type) {
		case Expose:
	   		doExpose((XExposeEvent *)theEvent);
	    	break;
		default:
	    	XeObject::doEvent(theEvent);
    }
    return 0;
}

void
XeProgressBar::setPosition(double pos)
{
	if (pos < 0)
		pos = 0;
	if (pos > _max)
		pos = _max;
		
	_position = pos;
	
	fillBar();

	XFlush(gDisplay);
}

void
XeProgressBar::fillBar(void)
{
	XRectangle r;
	
	r.x = _borderWidth;
	r.y = _borderWidth;
	r.height = _height - _borderWidth * 2;
	
	r.width = uint((_position / _max) * (_width - _borderWidth * 2));
	
	if (r.width >= _pixelPosition)
		XFillRectangle(gDisplay, _window, _barGC, r.x, r.y, r.width, r.height);
	else
		XClearArea(gDisplay, _window, r.x + r.width, r.y, _pixelPosition - r.width,
			r.height, False);
	
	_pixelPosition = r.width;
}

void
XeProgressBar::doExpose(XExposeEvent *)
{
	XRectangle r;
	
	r.x = 0; r.y = 0;
	r.width = _width;
	r.height = _height;

	drawBorder(r, _borderWidth, _shadowGC, _rshadowGC);
	fillBar();
}
