//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeOptionMenu.h,v 1.2 1999/07/18 10:33:10 ben Exp $

#ifndef _XeOptionMenu_H_
#define _XeOptionMenu_H_

#include <XeLabel.h>

class XeMenu;

class XeOptionMenu : public XeLabel {
public:
	XeOptionMenu(XeObject *parent, const char* name, 
		const char* className = "OptionMenu");
	~XeOptionMenu(void);
	
	int		doEvent(XEvent* theEvent);
	
	void	setLabel(const char* label);
	
	XeMenu*	getMenu(void) { return _menu; }
	int		getState(void) { return _state; }

private:
	XeMenu*	_menu;
	bool	_inMenu;
	int		_state;
	
	GC		_shadowGC, _rshadowGC;
	
	void doButton(XButtonEvent *);
	void doMotion(XMotionEvent *);
	void doExpose(void);
	
	void menuCB(const void*);
};

#endif //_XeOptionMenu_H_
