//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeObjectTable.C,v 1.1 1996/11/17 09:39:19 ben Exp $

#include <XeObjectTable.h>
#include <XeObject.h>
#include <stdio.h>

#define TABLESIZE 256

class ObjectTableElem {
private:
    ObjectTableElem *_prev, *_next;
    
    ulong _key;
    XeObject* _object;
    
    friend class XeObjectTable;
};

XeObjectTable::XeObjectTable(int size)
{
	_size = size;
    _table = new ObjectTableElem*[_size];
    for(int i=0; i<_size; i++) {
		_table[i] = NULL;
    }
}

XeObjectTable::~XeObjectTable(void)
{
    ObjectTableElem **head;
    ObjectTableElem *temp;
    
    for(int i=0; i<_size; i++) {
		head = &_table[i];
		while((temp = *head)) {
	    	*head = (*head)->_next;
	    	delete temp;
		}
    }
    delete[] _table;
}

uchar
XeObjectTable::hash(ulong key)
{
    uchar b1, b2, b3, b4;
    
    b1 = key & 0x000000ff;
    b2 = (key & 0x0000ff00) >> 8;
    b3 = (key & 0x00ff0000) >> 16;
    b4 = (key & 0xff000000) >> 24;
    
    return (b1 ^ b2 ^ b3 ^ b4) % _size;
}

void
XeObjectTable::addObject(XeObject* ob, ulong key)
{
    ObjectTableElem **head = &_table[hash(key)];
    ObjectTableElem *elem = new ObjectTableElem;
    
    elem->_key = key;
    elem->_object = ob;
    elem->_prev = NULL;
    
    if(*head) {
		(*head)->_prev = elem;
    }
    elem->_next = *head;
    *head = elem;
}

void
XeObjectTable::removeObject(ulong key)
{
    ObjectTableElem** head = &_table[hash(key)];
    ObjectTableElem* temp = *head;
    
    while(temp && (temp->_key != key))
		temp = temp->_next;

    if(temp) {
		if(temp->_next)
	    	temp->_next->_prev = temp->_prev;
		if(temp->_prev)
	    	temp->_prev->_next = temp->_next;
		else
	    	*head = temp->_next;
	
		delete temp;
    }
}

XeObject*
XeObjectTable::operator[](ulong key)
{
    ObjectTableElem* temp = _table[hash(key)];
    
    while(temp) {
		if(temp->_key == key)
	    	return temp->_object;
		temp = temp->_next;
    }
    return NULL;
}

bool
XeObjectTable::exists(ulong key)
{
    ObjectTableElem* temp = _table[hash(key)];
    
    while(temp) {
		if(temp->_key == key)
	    	return TRUE;
		temp = temp->_next;
    }
	return FALSE;
}

void
XeObjectTable::clearTable(void)
{
    ObjectTableElem *temp, *temp2;
    
    for(int i=0; i<_size; i++) {
		temp = _table[i];
		while(temp) {
			temp2 = temp;
			temp = temp->_next;
	    	delete temp2;
		}
		_table[i] = NULL;
    }
}
