//
// Copyright (C) 1996 Brian Murray
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeMiniAlloc.C,v 1.1 1996/11/17 09:37:29 ben Exp $

#include <Xe.h>
#include <XeMiniAlloc.h>

#define XE_MINI_CHUNK 1024

#define XE_MINI_PRIVATE(size)							\
														\
void* miniFree##size = NULL;							\
														\
void* miniAlloc##size(void)								\
{														\
	char* ptr = new char[XE_MINI_CHUNK];				\
	char* end = ptr + XE_MINI_CHUNK - size;				\
	char* last;											\
	*(void**)ptr = NULL;								\
	for (;;) {											\
		last = ptr;										\
		ptr += size;									\
		if (ptr > end)									\
			break;										\
		*(void**)ptr = last;							\
	}													\
	return (miniFree##size = last);						\
}														\

XE_MINI_PRIVATE(12)
//XE_MINI_PRIVATE(16)
XE_MINI_PRIVATE(32)
XE_MINI_PRIVATE(64);
