//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeMenuBar.h,v 1.3 1999/07/18 10:30:59 ben Exp $

#ifndef _XeMenuBar_H_
#define _XeMenuBar_H_

#include <XeWidget.h>

class XeMenu;
class XeMenuItem;
	
class XeMenuBar : public XeWidget {
public:
	XeMenuBar(XeObject* parent, char* name, 
		const char* className = "MenuBar");
	virtual ~XeMenuBar(void);
	
	virtual	int		doEvent(XEvent* event);
	virtual void	resizeEvent(uint width, uint height);
		
	void insertMenu(XeMenu* menu, char* label, bool global=FALSE);
	
private:
	// $$$ probably want to KrLinkify this list
	struct XeMenuStruct {
		XeMenuStruct *_next, *_prev;
	
		XRectangle	_rect;
		char*		_label;
		bool		_static;
		XeMenu*		_menu;
	};

	GC	_shadowGC, _rshadowGC, _backGC;
	int _borderWidth, _menuGap;
	bool	_inMenu;
	
	XeMenuStruct	*_head, *_tail, *_selected;
	
	void redraw();
	
	void doButton(XButtonEvent* event);
	void doMotion(XMotionEvent* event);
	void menuSelect(int x);
	void hilite(XeMenuStruct* header, bool state);
	void setRects();
	
	void menuCB(const void*);
	void menuSelect(XeObject*, ulong, void*);
	
};


#endif
