//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeMenu.h,v 1.2 1997/03/10 11:14:40 ben Exp $

#ifndef _XeMenu_H_
#define _XeMenu_H_

#include <XeWidget.h>

class XeMenu;
class XeMenuItem;

struct XeMenuCBData {
	XeMenuItem*	_item;
	XeMenu*		_menu;
};

class XeMenu : public XeWidget {
public:
	XeMenu(XeObject* parent, char* name, 
		const char* className = "Menu");
	virtual ~XeMenu(void);
	
	virtual	int		doEvent(XEvent* event);
	virtual int		commandKey(KeySym key, uint modifiers);
	
	void	insertItem(XeMenuItem *item);
	void	removeItem(XeMenuItem* item);
	void	insertTextItem(char* name, char* label, char* klabel=NULL, 
								KeySym cmdKey=0, uint modifiers=0);
	void	insertSeparator(void);
	
	XeMenuItem*	getItem(int index);
	
private:
	GC	_shadowGC, _rshadowGC, _backGC, _hiliteGC;
	int _borderWidth, _menuGap;
	
	KrLink			_itemList;
	XeMenuItem*		_selected, *_widest;
	
	int	_leftMargin, _rightMargin;
	
	void	refresh(void);
	
	void	doExpose(XExposeEvent*);
	void	doMotion(XMotionEvent*);
	void	doMotion(int x, int y);
	void	doLeaveNotify(void);
	void	doSelect(void);

	friend class XeMenuBar;
	friend class XeOptionMenu;
	
	friend class XeMenuItem;
	friend class XeTextItem;
	friend class XeSeparatorItem;
};

//
// Menu Item definitions.
//

class XeMenuItem : public KrLink {
public:
	enum ItemType {
		XE_TEXT_ITEM,
		XE_SEPARATOR
	};

	XeMenuItem(XeMenu *menu);
	virtual ~XeMenuItem(void);
	
	virtual void	draw(void) = 0;
	virtual void	hilite(bool) = 0;
	
	int		index() { return _index; }
	void	disable() { _disabled = TRUE; }
	void	enable() { _disabled = FALSE; }
	
protected:

	XRectangle	_rect;
	XeMenu*		_menu;
	ItemType	_type;
	bool		_disabled;
	int			_index;
	KeySym		_cmdKey;
	uint		_modifiers;
	
	static int	_hiliteWidth;
	
	void		getResources(void);
	
	friend class XeMenu;
	friend class XeTextItem; // $$$ this shouldn't be necessary ?
};

#define XE_TEXTITEM_KEYLEN 10

class XeTextItem : public XeMenuItem {
public:
	XeTextItem(XeMenu* menu, char* name, char* label, char* klabel=NULL, 
						KeySym cmdKey=0, uint modifiers=0);
	virtual ~XeTextItem(void);
	
	virtual void draw(void);
	virtual void hilite(bool state);
	
	const char*	getLabel(void) { return (const char*)_label; }
	
	void	setLabel(const char*);
	
protected:
	KrAtom			_name;
	char			*_label, _keyStr[XE_TEXTITEM_KEYLEN + 15];
	GC				_textGC;
	GC				_disabledGC;
	XFontStruct*	_font;
	
	friend XeMenu;
};

class XeSeparatorItem : public XeMenuItem {
public:
	XeSeparatorItem(XeMenu* menu);
	~XeSeparatorItem(void);
	
	void draw(void);
	void hilite(bool) {};
	
};

#endif
