//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeLabel.h,v 1.2 1997/03/24 11:10:45 ben Exp $

#ifndef _XeLabel_H_
#define _XeLabel_H_

#include <XeWidget.h>

class XeLabel : public XeWidget {
public:
	enum JustfyType {
		XE_JUSTIFY_LEFT,
		XE_JUSTIFY_RIGHT,
		XE_JUSTIFY_CENTRE
	};
	
    XeLabel(XeObject* parent, const char* name, 
    	const char* className="Label");
    virtual ~XeLabel(void);
        
    virtual int	    doEvent(XEvent *theEvent);
        
    // Set Functions:
    void    setLabel(const char* label);
    void    setFont(const char* fontname);
	void	setInset(int inset) { _inset = inset; }
    void	setAutoSize(bool asize) { _autoSize = asize; }
    void	setJustify(JustfyType justify) { _justify = justify; }
    void	setBorderWidth(int inset) { _borderWidth = inset; }
    
    // Get Functions:
    const char*	getLabel(void) { return _label; }
    
protected:
    char*		_label;
    int			_inset, _numLines, _leading, _borderWidth;
    JustfyType	_justify;
    bool		_autoSize;
    uint			_bufLen;
    
    void drawText(void);
    void autoSize(void);
};

#endif
