//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeKeyTable.h,v 1.5 1999/07/31 05:36:31 ben Exp $

#ifndef _XeKeyTable_H_
#define _XeKeyTable_H_

#include <XeHash.h>
#include <X11/Xlib.h>

typedef void (*KeyFunc)(void* aux);

class XeKeyTable : public XeHash {
public:
	XeKeyTable(int size = DEFAULT_SIZE) : XeHash(size) {}
	~XeKeyTable(void) {}
	
	void*		lookup(KeySym key, uint& modifiers);
	
	int			add(void* ob, KeySym key, uint modifiers);
	void		remove(KeySym key, uint modifiers);
};

//
// PC Keyboard key modifier masks not explicity defined in X.h
//
#define XeNumLockMask		Mod2Mask
#define XeScrollLockMask	Mod5Mask

#endif
