//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeKeyTable.C,v 1.3 1999/07/31 05:36:51 ben Exp $

#include <XeKeyTable.h>

void*
XeKeyTable::lookup(KeySym key, uint& modifiers)
{
	// clear LockMask, and PC scroll lock and numlock from modifiers
	//
	modifiers &= (~LockMask & ~XeNumLockMask & ~XeScrollLockMask);
	
	ulong tablekey;
	
	tablekey = ulong(key) | ulong((modifiers & 0x000000ff) << 16);
	return XeHash::lookup(tablekey);
}

int
XeKeyTable::add(void* ob, KeySym key, uint modifiers)
{
	ulong tablekey;
	
	tablekey = ulong(key) | ulong((modifiers & 0x000000ff) << 16);
	
	if (exists(tablekey))
		return 1;
	
	XeHash::add(ob, tablekey);
	return 0;
}

void
XeKeyTable::remove(KeySym key, uint modifiers)
{
	ulong tablekey;
	
	tablekey = ulong(key) | ulong((modifiers & 0x000000ff) << 16);
	XeHash::remove(tablekey);
}
