//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeHash.h,v 1.1 1996/12/01 01:55:41 ben Exp $

#ifndef _XeHash_H_
#define _XeHash_H_

#include <Xe.h>

// Hash table  of void* pointers hashed on a ulong key.
// Used by XeObjectTable and XeKeyTable

class XeHash {
public:
	enum {
		DEFAULT_SIZE = 64
	};
	
	XeHash(int size = DEFAULT_SIZE);
	~XeHash(void);
	
	void	add(void* data, ulong key);
	void	remove(ulong key);
	
	void*	lookup(ulong key);
	bool	exists(ulong key);
	
	void	clear(void);
	
private:
	struct Elem {
		Elem*	next;
		Elem*	prev;
		
		ulong	key;
		void*	data;
	};
	
	Elem**	_table;
	int		_size;

	uchar	hash(ulong key);
};

#endif
