//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeHash.C,v 1.1 1996/12/01 01:55:41 ben Exp $

#include <XeHash.h>

XeHash::XeHash(int size)
{
	_size = size;
    _table = new Elem*[_size];
    
    for (int i=0; i<_size; i++) {
		_table[i] = NULL;
    }
}

XeHash::~XeHash(void)
{
    Elem** head;
    Elem* temp;
    
    for(int i=0; i<_size; i++) {
		head = &_table[i];
		while((temp = *head)) {
	    	*head = (*head)->next;
	    	delete temp;
		}
    }
    delete[] _table;
}

void
XeHash::add(void* data, ulong key)
{
    Elem** head = &_table[hash(key)];
    Elem* temp = *head;
    
    while (temp) {
		if (temp->key == key) {
	    	temp->data = data;
	    	return;
	    }
		temp = temp->next;
    }
    
    Elem *elem = new Elem;
    
    elem->key = key;
    elem->data = data;
    elem->prev = NULL;
    
    if (*head) {
		(*head)->prev = elem;
    }
    elem->next = *head;
    *head = elem;
}

void
XeHash::remove(ulong key)
{
    Elem** head = &_table[hash(key)];
    Elem* temp = *head;
    
    while(temp && (temp->key != key))
		temp = temp->next;

    if(temp) {
		if(temp->next)
	    	temp->next->prev = temp->prev;
		if(temp->prev)
	    	temp->prev->next = temp->next;
		else
	    	*head = temp->next;
	
		delete temp;
    }
}

void*
XeHash::lookup(ulong key)
{
    Elem* temp = _table[hash(key)];
    
    while (temp) {
		if (temp->key == key)
	    	return temp->data;
		temp = temp->next;
    }
    
    return NULL;
}

bool
XeHash::exists(ulong key)
{
    Elem* temp = _table[hash(key)];
    
    while (temp) {
		if (temp->key == key)
	    	return TRUE;
		temp = temp->next;
    }
	return FALSE;
}

void
XeHash::clear(void)
{
    Elem *temp, *temp2;
    
    for (int i=0; i<_size; i++) {
		temp = _table[i];
		
		while (temp) {
			temp2 = temp;
			temp = temp->next;
	    	delete temp2;
		}
		_table[i] = NULL;
    }
}

uchar
XeHash::hash(ulong key)
{
    uchar b1, b2, b3, b4;
    
    b1 = key & 0x000000ff;
    b2 = (key & 0x0000ff00) >> 8;
    b3 = (key & 0x00ff0000) >> 16;
    b4 = (key & 0xff000000) >> 24;
    
    return (b1 ^ b2 ^ b3 ^ b4) % _size;
}
