//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeGCTable.h,v 1.1 1996/11/17 09:25:47 ben Exp $

#ifndef _XeGCTable_H_
#define _XeGCTable_H_

#include <Xe.h>
#include <X11/Xlib.h>

class TableElem {
private:
	TableElem *_prev, *_next;
	
	XGCValues _key;
	GC _gContext;
	
	friend class XeGCTable;
};

class XeGCTable {
public:
    XeGCTable(void);
    ~XeGCTable(void);
    
    GC		getGC(Window w, XGCValues* key, ulong flags);
    
    void	addGC(GC gc, XGCValues* key, ulong flags);
    
    GC	exists(XGCValues* key, ulong flags);
    
private:
    TableElem**	    _table;
    
    uchar		charify(ulong val);
    uchar	    hash(XGCValues* key, ulong flags);
    bool		compare(XGCValues* k1, XGCValues* k2, ulong flags);
};

#endif
